/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.http.support.internal.client;

import io.qameta.allure.Feature;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mule.runtime.http.api.sse.ServerSentEvent;
import org.mule.runtime.http.support.internal.client.SseListenerWrapper;
import org.mule.sdk.api.http.sse.client.SseListener;

@Feature(value="HTTP Forward Compatibility")
@ExtendWith(value={MockitoExtension.class})
class SseListenerWrapperTestCase {
    @Mock
    private SseListener listenerWrapper;
    @Mock
    private ServerSentEvent muleSseEvent;
    private SseListenerWrapper sseEventWrapper;

    SseListenerWrapperTestCase() {
    }

    @BeforeEach
    void setUp() {
        this.sseEventWrapper = new SseListenerWrapper(this.listenerWrapper);
    }

    @Test
    void delegateOnEvent() {
        String theData = "The Capiangos were the Federal wolf-men";
        Mockito.when((Object)this.muleSseEvent.getData()).thenReturn((Object)theData);
        this.sseEventWrapper.onEvent(this.muleSseEvent);
        ArgumentCaptor eventWrapperCaptor = ArgumentCaptor.forClass(org.mule.sdk.api.http.sse.ServerSentEvent.class);
        ((SseListener)Mockito.verify((Object)this.listenerWrapper)).onEvent((org.mule.sdk.api.http.sse.ServerSentEvent)eventWrapperCaptor.capture());
        org.mule.sdk.api.http.sse.ServerSentEvent eventWrapper = (org.mule.sdk.api.http.sse.ServerSentEvent)eventWrapperCaptor.getValue();
        MatcherAssert.assertThat((Object)eventWrapper.getData(), (Matcher)Matchers.is((Object)theData));
    }

    @Test
    void delegateOnClose() {
        this.sseEventWrapper.onClose();
        ((SseListener)Mockito.verify((Object)this.listenerWrapper)).onClose();
    }
}

