/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.http.support.internal.client;

import io.qameta.allure.Feature;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.Mock;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.junit.jupiter.MockitoSettings;
import org.mockito.quality.Strictness;
import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.runtime.http.api.client.HttpClientConfiguration;
import org.mule.runtime.http.api.client.proxy.ProxyConfig;
import org.mule.runtime.http.api.tcp.TcpClientSocketProperties;
import org.mule.runtime.http.support.internal.client.HttpClientConfigToBuilder;

@Feature(value="HTTP Forward Compatibility")
@ExtendWith(value={MockitoExtension.class})
@MockitoSettings(strictness=Strictness.LENIENT)
class HttpClientConfigToBuilderTestCase {
    private HttpClientConfiguration.Builder actualBuilder;
    @Mock
    private TlsContextFactory tlsContextFactory;
    private HttpClientConfigToBuilder configurer;

    HttpClientConfigToBuilderTestCase() {
    }

    @BeforeEach
    void setUp() {
        this.actualBuilder = new HttpClientConfiguration.Builder();
        this.configurer = new HttpClientConfigToBuilder(this.actualBuilder);
    }

    @Test
    void nameIsMandatory() {
        NullPointerException exceptionWhenNoName = (NullPointerException)Assertions.assertThrows(NullPointerException.class, () -> ((HttpClientConfiguration.Builder)this.actualBuilder).build());
        MatcherAssert.assertThat((Object)exceptionWhenNoName.getMessage(), (Matcher)Matchers.containsString((String)"Name is mandatory"));
    }

    @Test
    void testSetName() {
        String name = "test-client";
        this.configurer.setName(name);
        HttpClientConfiguration config = this.actualBuilder.build();
        MatcherAssert.assertThat((Object)config.getName(), (Matcher)Matchers.is((Object)name));
    }

    @Test
    void setTlsContextFactory() {
        this.configurer.setName("test-client").setTlsContextFactory(this.tlsContextFactory);
        HttpClientConfiguration config = this.actualBuilder.build();
        MatcherAssert.assertThat((Object)config.getTlsContextFactory(), (Matcher)Matchers.is((Object)this.tlsContextFactory));
    }

    @ParameterizedTest
    @ValueSource(ints={10, 20})
    void setMaxConnections(int maxConnections) {
        this.configurer.setName("test-client").setMaxConnections(maxConnections);
        HttpClientConfiguration config = this.actualBuilder.build();
        MatcherAssert.assertThat((Object)config.getMaxConnections(), (Matcher)Matchers.is((Object)maxConnections));
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    void setUsePersistentConnections(boolean usePersistentConnections) {
        this.configurer.setName("test-client").setUsePersistentConnections(usePersistentConnections);
        HttpClientConfiguration config = this.actualBuilder.build();
        MatcherAssert.assertThat((Object)config.isUsePersistentConnections(), (Matcher)Matchers.is((Object)usePersistentConnections));
    }

    @ParameterizedTest
    @ValueSource(ints={1024, 2048})
    void setConnectionIdleTimeout(int timeout) {
        this.configurer.setName("test-client").setConnectionIdleTimeout(timeout);
        HttpClientConfiguration config = this.actualBuilder.build();
        MatcherAssert.assertThat((Object)config.getConnectionIdleTimeout(), (Matcher)Matchers.is((Object)timeout));
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    void setStreaming(boolean streaming) {
        this.configurer.setName("test-client").setStreaming(streaming);
        HttpClientConfiguration config = this.actualBuilder.build();
        MatcherAssert.assertThat((Object)config.isStreaming(), (Matcher)Matchers.is((Object)streaming));
    }

    @ParameterizedTest
    @ValueSource(ints={1024, 2048})
    void setResponseBufferSize(int bufferSize) {
        this.configurer.setName("test-client").setResponseBufferSize(bufferSize);
        HttpClientConfiguration config = this.actualBuilder.build();
        MatcherAssert.assertThat((Object)config.getResponseBufferSize(), (Matcher)Matchers.is((Object)bufferSize));
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    void testSetDecompress(boolean decompress) {
        this.configurer.setName("test-client").setDecompress(Boolean.valueOf(decompress));
        HttpClientConfiguration config = this.actualBuilder.build();
        MatcherAssert.assertThat((Object)config.isDecompress(), (Matcher)Matchers.is((Object)decompress));
    }

    @Test
    void testConfigClientSocketProperties() {
        int sendBufferSize = 1234;
        int linger = 50;
        this.configurer.setName("test-client").configClientSocketProperties(config -> {
            config.sendBufferSize(Integer.valueOf(sendBufferSize));
            config.linger(Integer.valueOf(linger));
        });
        HttpClientConfiguration config2 = this.actualBuilder.build();
        TcpClientSocketProperties socketProperties = config2.getClientSocketProperties();
        MatcherAssert.assertThat((Object)socketProperties.getSendBufferSize(), (Matcher)Matchers.is((Object)sendBufferSize));
        MatcherAssert.assertThat((Object)socketProperties.getLinger(), (Matcher)Matchers.is((Object)linger));
    }

    @Test
    void testConfigProxy() {
        String proxyHost = "proxy.example.com";
        int proxyPort = 1234;
        String proxyUser = "user";
        String proxyPassword = "password";
        this.configurer.setName("test-client").configProxy(config -> config.host(proxyHost).port(proxyPort).auth(auth -> auth.basic(proxyUser, proxyPassword, false)));
        HttpClientConfiguration config2 = this.actualBuilder.build();
        ProxyConfig proxyConfig = config2.getProxyConfig();
        MatcherAssert.assertThat((Object)proxyConfig.getHost(), (Matcher)Matchers.is((Object)proxyHost));
        MatcherAssert.assertThat((Object)proxyConfig.getUsername(), (Matcher)Matchers.is((Object)proxyUser));
        MatcherAssert.assertThat((Object)proxyConfig.getPassword(), (Matcher)Matchers.is((Object)proxyPassword));
        MatcherAssert.assertThat((Object)proxyConfig.getPort(), (Matcher)Matchers.is((Object)proxyPort));
    }
}

