/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.http.support.internal.client;

import io.qameta.allure.Feature;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.junit.jupiter.MockitoSettings;
import org.mockito.quality.Strictness;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.HttpRequestOptions;
import org.mule.runtime.http.api.sse.client.SseListener;
import org.mule.runtime.http.api.sse.client.SseSource;
import org.mule.runtime.http.api.sse.client.SseSourceConfig;
import org.mule.runtime.http.support.internal.client.HttpClientWrapper;
import org.mule.sdk.api.http.domain.message.request.HttpRequest;
import org.mule.sdk.api.http.domain.message.response.HttpResponse;

@Feature(value="HTTP Forward Compatibility")
@ExtendWith(value={MockitoExtension.class})
@MockitoSettings(strictness=Strictness.LENIENT)
class HttpClientWrapperTestCase {
    @Mock
    private HttpClient delegateClient;
    @Mock
    private HttpRequest sdkRequest;
    @Mock
    private org.mule.runtime.http.api.domain.message.response.HttpResponse muleResponse;
    @Mock
    private SseSource muleSseSource;
    private HttpClientWrapper clientWrapper;

    HttpClientWrapperTestCase() {
    }

    @BeforeEach
    void setUp() {
        this.clientWrapper = new HttpClientWrapper(this.delegateClient);
    }

    @Test
    void sendAsyncForwardsRequestAndOptions() throws Exception {
        CompletableFuture<org.mule.runtime.http.api.domain.message.response.HttpResponse> delegateFuture = CompletableFuture.completedFuture(this.muleResponse);
        Mockito.when((Object)this.delegateClient.sendAsync((org.mule.runtime.http.api.domain.message.request.HttpRequest)ArgumentMatchers.any(), (HttpRequestOptions)ArgumentMatchers.any(HttpRequestOptions.class))).thenReturn(delegateFuture);
        int customResponseTimeout = 1234;
        Mockito.when((Object)this.sdkRequest.getMethod()).thenReturn((Object)"HEAD");
        CompletableFuture result = this.clientWrapper.sendAsync(this.sdkRequest, config -> config.setResponseTimeout(customResponseTimeout));
        ArgumentCaptor muleRequestCaptor = ArgumentCaptor.forClass(org.mule.runtime.http.api.domain.message.request.HttpRequest.class);
        ArgumentCaptor muleOptionsCaptor = ArgumentCaptor.forClass(HttpRequestOptions.class);
        MatcherAssert.assertThat((Object)((HttpResponse)result.get()), (Matcher)Matchers.notNullValue());
        ((HttpClient)Mockito.verify((Object)this.delegateClient)).sendAsync((org.mule.runtime.http.api.domain.message.request.HttpRequest)muleRequestCaptor.capture(), (HttpRequestOptions)muleOptionsCaptor.capture());
        MatcherAssert.assertThat((Object)((HttpRequestOptions)muleOptionsCaptor.getValue()).getResponseTimeout(), (Matcher)Matchers.is((Object)customResponseTimeout));
        MatcherAssert.assertThat((Object)((org.mule.runtime.http.api.domain.message.request.HttpRequest)muleRequestCaptor.getValue()).getMethod(), (Matcher)Matchers.is((Object)"HEAD"));
    }

    @Test
    void sendAsyncWithException() {
        RuntimeException expectedException = new RuntimeException("Test error");
        CompletableFuture delegateFuture = CompletableFuture.failedFuture(expectedException);
        Mockito.when((Object)this.delegateClient.sendAsync((org.mule.runtime.http.api.domain.message.request.HttpRequest)ArgumentMatchers.any(), (HttpRequestOptions)ArgumentMatchers.any(HttpRequestOptions.class))).thenReturn(delegateFuture);
        CompletableFuture result = this.clientWrapper.sendAsync(this.sdkRequest, config -> {});
        ExecutionException gotException = (ExecutionException)Assertions.assertThrows(ExecutionException.class, result::get);
        MatcherAssert.assertThat((Object)gotException.getCause(), (Matcher)Matchers.is((Object)expectedException));
    }

    @Test
    void getSseSource() {
        org.mule.sdk.api.http.sse.client.SseListener sdkListener = (org.mule.sdk.api.http.sse.client.SseListener)Mockito.mock(org.mule.sdk.api.http.sse.client.SseListener.class);
        Mockito.when((Object)this.delegateClient.sseSource((SseSourceConfig)ArgumentMatchers.any())).thenReturn((Object)this.muleSseSource);
        org.mule.sdk.api.http.sse.client.SseSource sseSource = this.clientWrapper.sseSource(config -> config.withUrl("/sse"));
        MatcherAssert.assertThat((Object)sseSource, (Matcher)Matchers.notNullValue());
        sseSource.register(sdkListener);
        ((SseSource)Mockito.verify((Object)this.muleSseSource)).register((SseListener)ArgumentMatchers.any());
    }

    @Test
    void delegateStart() {
        this.clientWrapper.start();
        ((HttpClient)Mockito.verify((Object)this.delegateClient)).start();
    }

    @Test
    void delegateStop() {
        this.clientWrapper.stop();
        ((HttpClient)Mockito.verify((Object)this.delegateClient)).stop();
    }
}

