/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.http.support.internal.server;

import io.qameta.allure.Feature;
import java.net.InetSocketAddress;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mule.runtime.http.api.sse.server.SseClientConfig;
import org.mule.runtime.http.support.internal.server.SseClientConfigImpl;
import org.mule.sdk.api.http.domain.message.request.ClientConnection;
import org.mule.sdk.api.http.domain.message.request.HttpRequestContext;

@Feature(value="HTTP Forward Compatibility")
@ExtendWith(value={MockitoExtension.class})
class SseClientConfigImplTestCase {
    private SseClientConfigImpl configurer;

    SseClientConfigImplTestCase() {
    }

    @BeforeEach
    void setUp() {
        this.configurer = new SseClientConfigImpl();
    }

    @Test
    void withRequestContext() {
        this.configurer.withRequestContext(null);
        SseClientConfig sseClientConfig = this.configurer.build();
        MatcherAssert.assertThat((Object)sseClientConfig.getRemoteHostAddress(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        HttpRequestContext requestContext = (HttpRequestContext)Mockito.mock(HttpRequestContext.class);
        this.configurer.withRequestContext(requestContext);
        sseClientConfig = this.configurer.build();
        MatcherAssert.assertThat((Object)sseClientConfig.getRemoteHostAddress(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        ClientConnection clientConnection = (ClientConnection)Mockito.mock(ClientConnection.class);
        Mockito.when((Object)requestContext.getClientConnection()).thenReturn((Object)clientConnection);
        this.configurer.withRequestContext(requestContext);
        sseClientConfig = this.configurer.build();
        MatcherAssert.assertThat((Object)sseClientConfig.getRemoteHostAddress(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        InetSocketAddress address = InetSocketAddress.createUnresolved("localhost", 1234);
        Mockito.when((Object)clientConnection.getRemoteHostAddress()).thenReturn((Object)address);
        this.configurer.withRequestContext(requestContext);
        sseClientConfig = this.configurer.build();
        MatcherAssert.assertThat((Object)sseClientConfig.getRemoteHostAddress(), (Matcher)Matchers.is((Object)address));
    }

    @Test
    void withClientId() {
        this.configurer.withClientId("18");
        SseClientConfig sseClientConfig = this.configurer.build();
        MatcherAssert.assertThat((Object)sseClientConfig.getClientId(), (Matcher)Matchers.is((Object)"18"));
    }

    @Test
    void withRemoteAddress() {
        InetSocketAddress address = InetSocketAddress.createUnresolved("localhost", 1234);
        this.configurer.withRemoteAddress(address);
        SseClientConfig sseClientConfig = this.configurer.build();
        MatcherAssert.assertThat((Object)sseClientConfig.getRemoteHostAddress(), (Matcher)Matchers.is((Object)address));
    }
}

