/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.http.support.internal.server;

import io.qameta.allure.Feature;
import java.util.function.Supplier;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.junit.jupiter.MockitoSettings;
import org.mockito.quality.Strictness;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.runtime.http.api.server.HttpServerConfiguration;
import org.mule.runtime.http.support.internal.server.HttpServerConfigToBuilder;

@Feature(value="HTTP Forward Compatibility")
@ExtendWith(value={MockitoExtension.class})
@MockitoSettings(strictness=Strictness.LENIENT)
class HttpServerConfigToBuilderTestCase {
    @Mock
    private HttpServerConfiguration.Builder mockBuilder;
    @Mock
    private TlsContextFactory tlsContextFactory;
    @Mock
    private Supplier<Scheduler> schedulerSupplier;
    private HttpServerConfigToBuilder configurer;

    HttpServerConfigToBuilderTestCase() {
    }

    @BeforeEach
    void setUp() {
        Mockito.when((Object)this.mockBuilder.setHost(ArgumentMatchers.anyString())).thenReturn((Object)this.mockBuilder);
        Mockito.when((Object)this.mockBuilder.setPort(ArgumentMatchers.anyInt())).thenReturn((Object)this.mockBuilder);
        Mockito.when((Object)this.mockBuilder.setTlsContextFactory((TlsContextFactory)ArgumentMatchers.any())).thenReturn((Object)this.mockBuilder);
        Mockito.when((Object)this.mockBuilder.setUsePersistentConnections(ArgumentMatchers.anyBoolean())).thenReturn((Object)this.mockBuilder);
        Mockito.when((Object)this.mockBuilder.setConnectionIdleTimeout(ArgumentMatchers.anyInt())).thenReturn((Object)this.mockBuilder);
        Mockito.when((Object)this.mockBuilder.setSchedulerSupplier((Supplier)ArgumentMatchers.any())).thenReturn((Object)this.mockBuilder);
        Mockito.when((Object)this.mockBuilder.setName(ArgumentMatchers.anyString())).thenReturn((Object)this.mockBuilder);
        Mockito.when((Object)this.mockBuilder.setReadTimeout(ArgumentMatchers.anyLong())).thenReturn((Object)this.mockBuilder);
        this.configurer = new HttpServerConfigToBuilder(this.mockBuilder);
    }

    @Test
    void setHost() {
        this.configurer.setHost("localhost");
        ((HttpServerConfiguration.Builder)Mockito.verify((Object)this.mockBuilder)).setHost("localhost");
    }

    @Test
    void setPort() {
        this.configurer.setPort(8080);
        ((HttpServerConfiguration.Builder)Mockito.verify((Object)this.mockBuilder)).setPort(8080);
    }

    @Test
    void setTlsContextFactory() {
        this.configurer.setTlsContextFactory(this.tlsContextFactory);
        ((HttpServerConfiguration.Builder)Mockito.verify((Object)this.mockBuilder)).setTlsContextFactory(this.tlsContextFactory);
    }

    @Test
    void setUsePersistentConnections() {
        this.configurer.setUsePersistentConnections(true);
        ((HttpServerConfiguration.Builder)Mockito.verify((Object)this.mockBuilder)).setUsePersistentConnections(true);
    }

    @Test
    void setConnectionIdleTimeout() {
        this.configurer.setConnectionIdleTimeout(30000);
        ((HttpServerConfiguration.Builder)Mockito.verify((Object)this.mockBuilder)).setConnectionIdleTimeout(30000);
    }

    @Test
    void setSchedulerSupplier() {
        this.configurer.setSchedulerSupplier(this.schedulerSupplier);
        ((HttpServerConfiguration.Builder)Mockito.verify((Object)this.mockBuilder)).setSchedulerSupplier(this.schedulerSupplier);
    }

    @Test
    void setName() {
        this.configurer.setName("test-server");
        ((HttpServerConfiguration.Builder)Mockito.verify((Object)this.mockBuilder)).setName("test-server");
    }

    @Test
    void setReadTimeout() {
        this.configurer.setReadTimeout(5000L);
        ((HttpServerConfiguration.Builder)Mockito.verify((Object)this.mockBuilder)).setReadTimeout(5000L);
    }
}

