/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

import org.mule.runtime.config.internal.builders.DefaultMinimalConfigurationBuilderSuplier;
import org.mule.runtime.core.api.config.builders.MinimalConfigurationBuilderSupplier;

/**
 * Support for dependency injection within a Mule Runtime artifact
 *
 * @moduleGraph
 * @since 4.11
 */
module org.mule.runtime.ioc {

  requires org.mule.runtime.api;
  requires transitive org.mule.runtime.core;
  requires org.mule.runtime.memory.management;
  requires org.mule.runtime.metrics.api;
  requires org.mule.runtime.tracer.exporter.api;

  exports org.mule.runtime.config.internal.builders to
      org.mule.runtime.core;

  provides MinimalConfigurationBuilderSupplier with
      DefaultMinimalConfigurationBuilderSuplier;
}
