/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.launcher.log4j2;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import org.apache.logging.log4j.core.LoggerContext;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.deployment.model.api.application.ApplicationDescriptor;
import org.mule.runtime.deployment.model.api.domain.DomainDescriptor;
import org.mule.runtime.module.artifact.api.classloader.RegionClassLoader;
import org.mule.runtime.module.launcher.log4j2.ArtifactAwareContextSelector;
import org.mule.runtime.module.launcher.log4j2.MuleLoggerContextFactory;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
@RunWith(value=MockitoJUnitRunner.class)
public class MuleLoggerContextFactoryTestCase
extends AbstractMuleTestCase {
    private static final File CONFIG_LOCATION = new File("my/local/log4j2.xml");
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private RegionClassLoader classLoader;
    private ApplicationDescriptor artifactDescriptor;
    private DomainDescriptor artifactDescriptorDomain;

    @Before
    public void before() throws Exception {
        Mockito.when((Object)this.classLoader.getArtifactId()).thenReturn((Object)((Object)((Object)this)).getClass().getName());
        Mockito.when((Object)this.classLoader.findLocalResource("log4j2.xml")).thenReturn((Object)CONFIG_LOCATION.toURI().toURL());
        this.artifactDescriptor = (ApplicationDescriptor)Mockito.mock(ApplicationDescriptor.class);
        this.artifactDescriptorDomain = (DomainDescriptor)Mockito.mock(DomainDescriptor.class);
        Mockito.when((Object)this.classLoader.getArtifactDescriptor()).thenReturn((Object)this.artifactDescriptor);
    }

    @Test
    public void externalConf() throws IOException, URISyntaxException {
        File customLogConfig = new File(ClassUtils.getResource((String)"log4j2-test-custom.xml", ((Object)((Object)this)).getClass()).toURI());
        Assert.assertThat((Object)customLogConfig.exists(), (Matcher)CoreMatchers.is((Object)true));
        Mockito.when((Object)this.artifactDescriptor.getLogConfigFile()).thenReturn((Object)customLogConfig);
        MuleLoggerContextFactory loggerCtxFactory = this.mockLoggerContextFactory();
        LoggerContext ctx = loggerCtxFactory.build((ClassLoader)this.classLoader, (ArtifactAwareContextSelector)Mockito.mock(ArtifactAwareContextSelector.class));
        Assert.assertThat((Object)ctx.getConfigLocation(), (Matcher)CoreMatchers.equalTo((Object)customLogConfig.toURI()));
    }

    @Test
    public void externalConfInvalid() throws IOException {
        File customLogConfig = new File("src/test/resources/log4j2-test-custom-invalid.xml");
        Assert.assertThat((Object)customLogConfig.exists(), (Matcher)CoreMatchers.is((Object)false));
        Mockito.when((Object)this.artifactDescriptor.getLogConfigFile()).thenReturn((Object)customLogConfig);
        MuleLoggerContextFactory loggerCtxFactory = this.mockLoggerContextFactory();
        LoggerContext ctx = loggerCtxFactory.build((ClassLoader)this.classLoader, (ArtifactAwareContextSelector)Mockito.mock(ArtifactAwareContextSelector.class));
        Assert.assertThat((Object)ctx.getConfigLocation(), (Matcher)CoreMatchers.equalTo((Object)CONFIG_LOCATION.toURI()));
    }

    @Test
    public void externalConfDomain() throws IOException, URISyntaxException {
        Mockito.when((Object)this.classLoader.getArtifactDescriptor()).thenReturn((Object)this.artifactDescriptorDomain);
        File customLogConfig = new File(ClassUtils.getResource((String)"log4j2-test-custom.xml", ((Object)((Object)this)).getClass()).toURI());
        Assert.assertThat((Object)customLogConfig.exists(), (Matcher)CoreMatchers.is((Object)true));
        Mockito.when((Object)this.artifactDescriptorDomain.getLogConfigFile()).thenReturn((Object)customLogConfig);
        MuleLoggerContextFactory loggerCtxFactory = this.mockLoggerContextFactory();
        LoggerContext ctx = loggerCtxFactory.build((ClassLoader)this.classLoader, (ArtifactAwareContextSelector)Mockito.mock(ArtifactAwareContextSelector.class));
        Assert.assertThat((Object)ctx.getConfigLocation(), (Matcher)CoreMatchers.equalTo((Object)customLogConfig.toURI()));
    }

    protected MuleLoggerContextFactory mockLoggerContextFactory() throws IOException {
        return (MuleLoggerContextFactory)Mockito.spy((Object)new MuleLoggerContextFactory());
    }
}

