/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.launcher;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.spi.LoggerContextFactory;
import org.mule.runtime.api.exception.ExceptionHelper;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessage;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.service.ServiceRepository;
import org.mule.runtime.container.api.MuleFoldersUtil;
import org.mule.runtime.core.api.config.i18n.CoreMessages;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.internal.lock.ServerLockFactory;
import org.mule.runtime.core.internal.util.ClassUtils;
import org.mule.runtime.module.artifact.activation.api.extension.discovery.ExtensionModelLoaderRepository;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoader;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoaderManager;
import org.mule.runtime.module.artifact.api.classloader.net.MuleArtifactUrlStreamHandler;
import org.mule.runtime.module.artifact.api.classloader.net.MuleUrlStreamHandlerFactory;
import org.mule.runtime.module.artifact.internal.classloader.DefaultResourceInitializer;
import org.mule.runtime.module.boot.api.MuleContainer;
import org.mule.runtime.module.deployment.api.DeploymentService;
import org.mule.runtime.module.deployment.impl.internal.MuleArtifactResourcesRegistry;
import org.mule.runtime.module.deployment.internal.DeploymentServiceBuilder;
import org.mule.runtime.module.deployment.internal.MuleDeploymentService;
import org.mule.runtime.module.deployment.internal.processor.SerializedAstArtifactConfigurationProcessor;
import org.mule.runtime.module.launcher.coreextension.ClasspathMuleCoreExtensionDiscoverer;
import org.mule.runtime.module.launcher.coreextension.DefaultMuleCoreExtensionManagerServer;
import org.mule.runtime.module.launcher.coreextension.MuleCoreExtensionManagerServer;
import org.mule.runtime.module.launcher.coreextension.ReflectionMuleCoreExtensionDependencyResolver;
import org.mule.runtime.module.launcher.privileged.ContainerServiceProvider;
import org.mule.runtime.module.launcher.splash.MuleContainerStartupSplashScreen;
import org.mule.runtime.module.log4j.boot.api.MuleLog4jContextFactory;
import org.mule.runtime.module.log4j.internal.MuleLog4jConfiguratorUtils;
import org.mule.runtime.module.repository.api.RepositoryService;
import org.mule.runtime.module.repository.internal.RepositoryServiceFactory;
import org.mule.runtime.module.service.api.manager.ServiceManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultMuleContainer
implements MuleContainer {
    private static final Logger logger;
    private static final Logger SPLASH_LOGGER;
    private static MuleShutdownHook muleShutdownHook;
    protected final DeploymentService deploymentService;
    private final RepositoryService repositoryService;
    private final MuleCoreExtensionManagerServer coreExtensionManager;
    private ServerLockFactory muleLockFactory;
    private final MuleArtifactResourcesRegistry artifactResourcesRegistry = new MuleArtifactResourcesRegistry.Builder().artifactConfigurationProcessor(SerializedAstArtifactConfigurationProcessor.serializedAstWithFallbackArtifactConfigurationProcessor()).withActionOnMuleArtifactDeployment(MuleLog4jConfiguratorUtils.getDefaultReconfigurationAction()).withAdditionalResourceDirectory("").build();
    private Map<Class, Object> containerServices = new HashMap<Class, Object>();
    private static MuleLog4jContextFactory log4jContextFactory;
    private final ServiceManager serviceManager;
    private final ExtensionModelLoaderRepository extensionModelLoaderRepository;

    public DefaultMuleContainer() throws InitialisationException {
        this.init();
        this.serviceManager = this.artifactResourcesRegistry.getServiceManager();
        this.extensionModelLoaderRepository = this.artifactResourcesRegistry.getExtensionModelLoaderRepository();
        this.deploymentService = this.resolveDeploymentService();
        this.repositoryService = new RepositoryServiceFactory().createRepositoryService();
        this.coreExtensionManager = new DefaultMuleCoreExtensionManagerServer(new ClasspathMuleCoreExtensionDiscoverer(this.artifactResourcesRegistry.getContainerClassLoader()), new ReflectionMuleCoreExtensionDependencyResolver());
        this.muleLockFactory = new ServerLockFactory();
        ContainerServiceProvider.loadContainerServiceProviders().forEach(containerServiceProvider -> this.setService(containerServiceProvider.getServiceInterface(), containerServiceProvider.getServiceImplementation((ServiceRepository)this.serviceManager, this.deploymentService, this.artifactResourcesRegistry)));
        this.artifactResourcesRegistry.getContainerClassLoader().dispose();
    }

    private DeploymentService resolveDeploymentService() {
        return DeploymentServiceBuilder.deploymentServiceBuilder().withArtifactStartExecutorSupplier(() -> MuleDeploymentService.findSchedulerService((ServiceRepository)this.serviceManager)).withApplicationFactory(this.artifactResourcesRegistry.getApplicationFactory()).withDomainFactory(this.artifactResourcesRegistry.getDomainFactory()).withDeploymentFailureThrowableConsumer(this::attemptContainerShutdown).build();
    }

    DefaultMuleContainer(DeploymentService deploymentService, RepositoryService repositoryService, MuleCoreExtensionManagerServer coreExtensionManager, ServiceManager serviceManager, ExtensionModelLoaderRepository extensionModelLoaderRepository, Map<Class, Object> containerServices) throws IllegalArgumentException, InitialisationException {
        this.init();
        this.deploymentService = deploymentService;
        this.coreExtensionManager = coreExtensionManager;
        this.repositoryService = repositoryService;
        this.serviceManager = serviceManager;
        this.extensionModelLoaderRepository = extensionModelLoaderRepository;
        this.containerServices.putAll(containerServices);
    }

    protected void init() throws IllegalArgumentException, InitialisationException {
        MuleUrlStreamHandlerFactory.installUrlStreamHandlerFactory();
        MuleArtifactUrlStreamHandler.register();
        this.artifactResourcesRegistry.getMemoryManagementService().initialise();
        this.artifactResourcesRegistry.inject((Object)this.artifactResourcesRegistry.getContainerProfilingService());
        LifecycleUtils.initialiseIfNeeded((Object)this.artifactResourcesRegistry.getContainerProfilingService());
    }

    private void createExecutionMuleFolder() {
        File executionFolder = MuleFoldersUtil.getExecutionFolder();
        if (!executionFolder.exists() && !executionFolder.mkdirs()) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)String.format("Could not create folder %s, validate that the process has permissions over that directory", executionFolder.getAbsolutePath())));
        }
    }

    public void start(Future<Boolean> configurationsReady, List<String> additionalSplashEntries) throws MuleException {
        this.start(true, configurationsReady, additionalSplashEntries);
    }

    public void start(boolean registerShutdownHook) throws MuleException {
        this.start(registerShutdownHook, CompletableFuture.completedFuture(true), Collections.emptyList());
    }

    private void start(boolean registerShutdownHook, Future<Boolean> configurationsReady, List<String> additionalSplashEntries) throws MuleException {
        if (registerShutdownHook) {
            this.registerShutdownHook();
        }
        try {
            LifecycleUtils.startIfNeeded((Object)this.artifactResourcesRegistry.getContainerProfilingService());
            this.doResourceInitialization();
            this.createExecutionMuleFolder();
            this.serviceManager.start();
            this.coreExtensionManager.setDeploymentService(this.deploymentService);
            this.coreExtensionManager.setRepositoryService(this.repositoryService);
            this.coreExtensionManager.setArtifactClassLoaderManager((ArtifactClassLoaderManager)this.artifactResourcesRegistry.getArtifactClassLoaderManager());
            this.coreExtensionManager.setServiceRepository((ServiceRepository)this.serviceManager);
            this.coreExtensionManager.setServerLockFactory(this.muleLockFactory);
            this.coreExtensionManager.setContainerServices(this.containerServices);
            if (!configurationsReady.get().booleanValue()) {
                this.shutdown();
            }
            this.showSplashScreen(additionalSplashEntries);
            this.coreExtensionManager.initialise();
            this.coreExtensionManager.start();
            LifecycleUtils.initialiseIfNeeded(this.containerServices.values());
            LifecycleUtils.startIfNeeded((Object)this.extensionModelLoaderRepository);
            this.deploymentService.start();
        }
        catch (MuleException e) {
            this.shutdown(e);
            throw e;
        }
        catch (Throwable t) {
            this.shutdown(t);
            throw new MuleRuntimeException(t);
        }
    }

    private void attemptContainerShutdown(Throwable e) {
        try {
            this.shutdown(e);
        }
        catch (Throwable t) {
            logger.error("Error on attempting to shutdown the container", t);
        }
        System.exit(1);
    }

    private void doResourceInitialization() {
        ClassUtils.withContextClassLoader((ClassLoader)ClassLoader.getSystemClassLoader(), () -> {
            try {
                new DefaultResourceInitializer().initialize();
            }
            catch (Exception e) {
                logger.error("Cannot create resource initializer instance", (Throwable)e);
            }
        });
    }

    private void showSplashScreen(List<String> additionalSplashEntries) {
        MuleContainerStartupSplashScreen splashScreen = new MuleContainerStartupSplashScreen(additionalSplashEntries);
        splashScreen.doBody();
        SPLASH_LOGGER.info(splashScreen.toString());
    }

    public void shutdown(Throwable e) throws MuleException {
        I18nMessage msg = CoreMessages.fatalErrorWhileRunning();
        MuleException muleException = ExceptionHelper.getRootMuleException((Throwable)e);
        if (muleException != null) {
            logger.error(muleException.getDetailedMessage());
        } else {
            logger.error(msg.toString() + " " + e.getMessage(), e);
        }
        logger.atError().log(() -> {
            ArrayList<Object> msgs = new ArrayList<Object>();
            msgs.add(msg.getMessage());
            Throwable root = ExceptionHelper.getRootException((Throwable)e);
            msgs.add(root.getMessage() + " (" + root.getClass().getName() + ")");
            msgs.add(" ");
            msgs.add(CoreMessages.fatalErrorInShutdown().getMessage());
            return msgs.stream().collect(Collectors.joining(System.lineSeparator()));
        });
        try {
            this.doShutdown();
        }
        catch (MuleException ex) {
            ex.addSuppressed(e);
            throw ex;
        }
    }

    public void shutdown() throws MuleException {
        logger.info("Mule container shutting down due to normal shutdown request");
        this.doShutdown();
    }

    protected void doShutdown() throws MuleException {
        this.unregisterShutdownHook();
        this.stop();
    }

    public void stop() throws MuleException {
        if (this.deploymentService != null) {
            this.deploymentService.stop();
        }
        if (this.muleLockFactory != null) {
            this.muleLockFactory.dispose();
        }
        if (this.extensionModelLoaderRepository != null) {
            LifecycleUtils.stopIfNeeded((Object)this.extensionModelLoaderRepository);
        }
        this.coreExtensionManager.stop();
        this.coreExtensionManager.dispose();
        if (this.serviceManager != null) {
            this.serviceManager.stop();
        }
        LifecycleUtils.stopIfNeeded(this.containerServices.values());
        LoggerContextFactory defaultLogManagerFactory = LogManager.getFactory();
        if (defaultLogManagerFactory instanceof MuleLog4jContextFactory) {
            ((MuleLog4jContextFactory)defaultLogManagerFactory).dispose();
        }
        if (log4jContextFactory != null && log4jContextFactory != defaultLogManagerFactory) {
            log4jContextFactory.dispose();
        }
        if (this.artifactResourcesRegistry.getDescriptorLoaderRepository() != null) {
            LifecycleUtils.disposeIfNeeded((Object)this.artifactResourcesRegistry.getDescriptorLoaderRepository(), (Logger)logger);
        }
        if (this.repositoryService != null) {
            LifecycleUtils.disposeIfNeeded((Object)this.repositoryService, (Logger)logger);
        }
        LifecycleUtils.disposeIfNeeded((Object)this.artifactResourcesRegistry, (Logger)logger);
    }

    public Logger getLogger() {
        return logger;
    }

    public void registerShutdownHook() {
        if (muleShutdownHook == null) {
            muleShutdownHook = new MuleShutdownHook();
        } else {
            Runtime.getRuntime().removeShutdownHook(muleShutdownHook);
        }
        Runtime.getRuntime().addShutdownHook(muleShutdownHook);
    }

    public void unregisterShutdownHook() {
        if (muleShutdownHook != null) {
            Runtime.getRuntime().removeShutdownHook(muleShutdownHook);
        }
    }

    public DeploymentService getDeploymentService() {
        return this.deploymentService;
    }

    public ArtifactClassLoader getContainerClassLoader() {
        return this.artifactResourcesRegistry.getContainerClassLoader();
    }

    public <S> void setService(Class<S> serviceInterface, S serviceInstance) {
        this.containerServices.put(serviceInterface, serviceInstance);
    }

    static {
        SPLASH_LOGGER = LoggerFactory.getLogger((String)"org.mule.runtime.core.internal.logging");
        if (System.getProperty("mule.simpleLog") == null) {
            LoggerContextFactory contextFactory = LogManager.getFactory();
            log4jContextFactory = contextFactory instanceof MuleLog4jContextFactory ? (MuleLog4jContextFactory)contextFactory : MuleLog4jContextFactory.createAndInstall();
            MuleLog4jConfiguratorUtils.configureSelector((MuleLog4jContextFactory)log4jContextFactory);
        }
        logger = LoggerFactory.getLogger(DefaultMuleContainer.class);
    }

    private class MuleShutdownHook
    extends Thread {
        public MuleShutdownHook() {
            super("Mule.shutdown.hook");
        }

        @Override
        public void run() {
            try {
                DefaultMuleContainer.this.stop();
            }
            catch (MuleException e) {
                logger.warn("Error stopping mule container", (Throwable)e);
            }
        }
    }
}

