/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.launcher;

import io.qameta.allure.Feature;
import java.io.File;
import java.util.Arrays;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.module.launcher.splash.MuleContainerStartupSplashScreen;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.junit4.matcher.StringContainsIgnoringLineBreaks;
import org.mule.tck.junit4.rule.SystemProperty;

@Feature(value="Artifact Patching")
public class MuleContainerStartupSplashScreenTestCase
extends AbstractMuleTestCase {
    private static final String FIRST_PATCH = "SE-4242-3.8.0.jar";
    private static final String SECOND_PATCH = "SE-9999-3.7.3.jar";
    private static final String MULE_PATCH = "MULE-1345-4.2.0.jar";
    private static final String LIBRARY_JAR = "library.jar";
    private static final String ARTIFACT_PATCH = "SE-12-1.0.0-1.2.3.jar";
    private static final String APIKIT_PATCH = "APIKIT-12-1.2.0-1.3.0.jar";
    private static final String COMPLEX_LOG_PART = "* Mule services:                                                     *\n*  - myService.zip                                                   *\n* Applied patches:                                                   *\n*  - MULE-1345-4.2.0.jar                                             *\n*  - SE-4242-3.8.0.jar                                               *\n*  - SE-9999-3.7.3.jar                                               *\n*  - library.jar                                                     *\n* Applied artifact patches:                                          *\n*  - APIKIT-12-1.2.0-1.3.0.jar                                       *\n*  - SE-12-1.0.0-1.2.3.jar                                           *\n* Mule system properties:                                            *\n";
    @ClassRule
    public static TemporaryFolder workingDirectory = new TemporaryFolder();
    @Rule
    public SystemProperty muleHome = new SystemProperty("mule.home", workingDirectory.getRoot().getAbsolutePath());
    private MuleContainerStartupSplashScreen splashScreen;

    @BeforeClass
    public static void setUpPatches() {
        File libFolder = new File(workingDirectory.getRoot(), "lib/patches");
        libFolder.mkdirs();
        new File(libFolder, FIRST_PATCH).mkdir();
        new File(libFolder, LIBRARY_JAR).mkdir();
        new File(libFolder, SECOND_PATCH).mkdir();
        new File(libFolder, MULE_PATCH).mkdir();
        File artifactPatchesFolder = new File(libFolder, "mule-artifact-patches");
        artifactPatchesFolder.mkdirs();
        new File(artifactPatchesFolder, ARTIFACT_PATCH).mkdir();
        new File(artifactPatchesFolder, APIKIT_PATCH).mkdir();
        File servicesFolder = new File(workingDirectory.getRoot(), "services");
        servicesFolder.mkdir();
        new File(servicesFolder, "myService.zip").mkdir();
    }

    @Before
    public void setUp() {
        this.splashScreen = new MuleContainerStartupSplashScreen(Arrays.asList("Additional splash entry 1", "Additional splash entry 2"));
    }

    @Test
    public void simpleLogWhenVerbosityOff() {
        try {
            System.setProperty("mule.runtime.verbose", "false");
            this.splashScreen.doBody();
            MatcherAssert.assertThat((Object)this.splashScreen.toString(), (Matcher)Matchers.not((Matcher)StringContainsIgnoringLineBreaks.containsStringIgnoringLineBreaks((String)COMPLEX_LOG_PART)));
        }
        finally {
            System.clearProperty("mule.runtime.verbose");
        }
    }

    @Test
    public void complexLogWhenVerbosityOn() {
        try {
            System.setProperty("mule.runtime.verbose", "true");
            this.splashScreen.doBody();
            MatcherAssert.assertThat((Object)this.splashScreen.toString(), (Matcher)StringContainsIgnoringLineBreaks.containsStringIgnoringLineBreaks((String)COMPLEX_LOG_PART));
        }
        finally {
            System.clearProperty("mule.runtime.verbose");
        }
    }

    @Test
    public void complexLogWhenNoVerbositySpecified() {
        Preconditions.checkArgument((System.getProperty("mule.runtime.verbose") == null ? 1 : 0) != 0, (String)"Runtime verbosity should not be specified.");
        this.splashScreen.doBody();
        MatcherAssert.assertThat((Object)this.splashScreen.toString(), (Matcher)StringContainsIgnoringLineBreaks.containsStringIgnoringLineBreaks((String)COMPLEX_LOG_PART));
    }
}

