/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.launcher.log4j2;

import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.core.config.xml.XmlConfigurationFactory;
import org.apache.logging.log4j.core.selector.ContextSelector;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.runtime.module.launcher.api.log4j2.AsyncLoggerExceptionHandler;
import org.mule.runtime.module.launcher.log4j2.ArtifactAwareContextSelector;
import org.mule.runtime.module.launcher.log4j2.MuleLog4jContextFactory;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
public class MuleLog4jContextFactoryTestCase
extends AbstractMuleTestCase {
    private static final String LOG_CONFIGURATION_FACTORY_PROPERTY = "log4j.configurationFactory";
    private static final String ASYNC_LOGGER_EXCEPTION_HANDLER_PROPERTY = "AsyncLoggerConfig.ExceptionHandler";
    private Map<String, String> originalSystemProperties;

    @Before
    public void before() {
        this.originalSystemProperties = new HashMap<String, String>();
        this.originalSystemProperties.put(LOG_CONFIGURATION_FACTORY_PROPERTY, System.getProperty(LOG_CONFIGURATION_FACTORY_PROPERTY));
        this.originalSystemProperties.put(ASYNC_LOGGER_EXCEPTION_HANDLER_PROPERTY, System.getProperty(ASYNC_LOGGER_EXCEPTION_HANDLER_PROPERTY));
    }

    @After
    public void after() {
        for (Map.Entry<String, String> entry : this.originalSystemProperties.entrySet()) {
            if (entry.getValue() != null) {
                System.setProperty(entry.getKey(), entry.getValue());
                continue;
            }
            System.clearProperty(entry.getKey());
        }
    }

    @Test
    public void systemProperties() {
        new MuleLog4jContextFactory();
        Assert.assertThat((Object)XmlConfigurationFactory.class.getName(), (Matcher)CoreMatchers.equalTo((Object)System.getProperty(LOG_CONFIGURATION_FACTORY_PROPERTY)));
        Assert.assertThat((Object)AsyncLoggerExceptionHandler.class.getName(), (Matcher)CoreMatchers.equalTo((Object)System.getProperty(ASYNC_LOGGER_EXCEPTION_HANDLER_PROPERTY)));
    }

    @Test
    public void customExceptionHandler() {
        String customHandler = "custom";
        System.setProperty(ASYNC_LOGGER_EXCEPTION_HANDLER_PROPERTY, "custom");
        new MuleLog4jContextFactory();
        Assert.assertThat((Object)"custom", (Matcher)CoreMatchers.equalTo((Object)System.getProperty(ASYNC_LOGGER_EXCEPTION_HANDLER_PROPERTY)));
    }

    @Test
    public void dispose() {
        ArtifactAwareContextSelector contextSelector = (ArtifactAwareContextSelector)Mockito.mock(ArtifactAwareContextSelector.class);
        MuleLog4jContextFactory factory = new MuleLog4jContextFactory((ContextSelector)contextSelector);
        factory.dispose();
        ((ArtifactAwareContextSelector)Mockito.verify((Object)contextSelector)).dispose();
    }
}

