/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.launcher.log4j2;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import org.apache.logging.log4j.core.LoggerContext;
import org.hamcrest.Matcher;
import org.hamcrest.collection.IsCollectionWithSize;
import org.hamcrest.core.IsCollectionContaining;
import org.hamcrest.core.IsEqual;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.module.artifact.api.classloader.RegionClassLoader;
import org.mule.runtime.module.launcher.log4j2.ArtifactAwareContextSelector;
import org.mule.runtime.module.launcher.log4j2.LoggerContextCache;
import org.mule.runtime.module.launcher.log4j2.MuleLoggerContext;
import org.mule.runtime.module.launcher.log4j2.RecursiveLoggerContextInstantiationException;
import org.mule.tck.size.SmallTest;

@SmallTest
@RunWith(value=MockitoJUnitRunner.class)
@Feature(value="Core Components")
@Story(value="Logger")
public class LoggerContextCacheTestCase {
    private ClassLoader currentClassLoader;
    private LoggerContextCache loggerContextCache;
    @Mock
    private RegionClassLoader regionClassLoader;
    @Mock
    private ArtifactAwareContextSelector contextSelector;

    @Before
    public void before() {
        this.loggerContextCache = new LoggerContextCache(this.contextSelector, this.currentClassLoader);
        this.currentClassLoader = Thread.currentThread().getContextClassLoader();
    }

    @After
    public void after() {
        this.loggerContextCache.dispose();
    }

    @Test
    public void whenRecursiveMuleLoggerContextInstantiationExpectRecursiveLoggerContextInstantiationExceptionAndRecovery() {
        LoggerContext actualLoggerContext;
        LoggerContext expectedLoggerContext = (LoggerContext)Mockito.mock(MuleLoggerContext.class);
        Mockito.when((Object)this.contextSelector.buildContext(this.currentClassLoader)).thenAnswer(invocation -> this.loggerContextCache.getLoggerContext(this.currentClassLoader)).thenReturn((Object)expectedLoggerContext);
        try {
            actualLoggerContext = this.loggerContextCache.getLoggerContext(this.currentClassLoader);
            Assert.fail((String)"Recursive instantiation should throw RecursiveLoggerContextInstantiationException");
        }
        catch (RecursiveLoggerContextInstantiationException e) {
            actualLoggerContext = this.loggerContextCache.getLoggerContext(this.currentClassLoader);
        }
        Assert.assertThat((String)"Invalid LoggerContext", (Object)actualLoggerContext, (Matcher)IsEqual.equalTo((Object)expectedLoggerContext));
    }

    @Test
    public void whenMuleRuntimeExceptionDuringMuleLoggerContextInstantiationExpectRecovery() {
        LoggerContext expectedLoggerContext = (LoggerContext)Mockito.mock(MuleLoggerContext.class);
        Mockito.when((Object)this.contextSelector.buildContext(this.currentClassLoader)).thenThrow(MuleRuntimeException.class).thenAnswer(invocation -> expectedLoggerContext);
        LoggerContext actualLoggerContext = null;
        try {
            this.loggerContextCache.getLoggerContext(this.currentClassLoader);
        }
        catch (MuleRuntimeException mre) {
            actualLoggerContext = this.loggerContextCache.getLoggerContext(this.currentClassLoader);
        }
        Assert.assertThat((String)"Invalid loggerContext", (Object)actualLoggerContext, (Matcher)IsEqual.equalTo((Object)expectedLoggerContext));
    }

    @Test
    public void whenMuleLoggerContextInstantiationExpectCacheStore() {
        LoggerContext firstExpectedLoggerContext = (LoggerContext)Mockito.mock(MuleLoggerContext.class);
        LoggerContext secondExpectedLoggerContext = (LoggerContext)Mockito.mock(MuleLoggerContext.class);
        Mockito.when((Object)this.contextSelector.buildContext(this.currentClassLoader)).thenReturn((Object)firstExpectedLoggerContext);
        Mockito.when((Object)this.contextSelector.buildContext((ClassLoader)this.regionClassLoader)).thenReturn((Object)secondExpectedLoggerContext);
        this.loggerContextCache.getLoggerContext(this.currentClassLoader);
        ClassUtils.withContextClassLoader((ClassLoader)this.regionClassLoader, () -> this.loggerContextCache.getLoggerContext((ClassLoader)this.regionClassLoader));
        Assert.assertThat((String)"Additional or missing LoggerContext instances found in cache", (Object)this.loggerContextCache.getAllLoggerContexts(), (Matcher)IsCollectionWithSize.hasSize((int)2));
        Assert.assertThat((Object)this.loggerContextCache.getAllLoggerContexts(), (Matcher)IsCollectionContaining.hasItem((Object)firstExpectedLoggerContext));
        Assert.assertThat((Object)this.loggerContextCache.getAllLoggerContexts(), (Matcher)IsCollectionContaining.hasItem((Object)secondExpectedLoggerContext));
    }
}

