/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.launcher.log4j2;

import java.io.File;
import java.net.URISyntaxException;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.selector.ContextSelector;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Answers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnit;
import org.mockito.junit.MockitoRule;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.deployment.model.api.application.ApplicationDescriptor;
import org.mule.runtime.deployment.model.api.domain.DomainDescriptor;
import org.mule.runtime.module.artifact.api.classloader.RegionClassLoader;
import org.mule.runtime.module.launcher.log4j2.ArtifactAwareContextSelector;
import org.mule.runtime.module.launcher.log4j2.DispatchingLogger;
import org.mule.runtime.module.launcher.log4j2.MuleLoggerContextFactory;
import org.mule.runtime.module.launcher.log4j2.SimpleContextSelector;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
public class MuleLoggerContextFactoryTestCase
extends AbstractMuleTestCase {
    private static final File CONFIG_LOCATION = new File("my/local/log4j2.xml");
    @Rule
    public MockitoRule rule = MockitoJUnit.rule();
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private RegionClassLoader classLoader;
    private ApplicationDescriptor artifactDescriptor;
    private DomainDescriptor artifactDescriptorDomain;

    @Before
    public void before() throws Exception {
        Mockito.when((Object)this.classLoader.getArtifactId()).thenReturn((Object)((Object)((Object)this)).getClass().getName());
        Mockito.when((Object)this.classLoader.findLocalResource("log4j2.xml")).thenReturn((Object)CONFIG_LOCATION.toURI().toURL());
        this.artifactDescriptor = (ApplicationDescriptor)Mockito.mock(ApplicationDescriptor.class);
        this.artifactDescriptorDomain = (DomainDescriptor)Mockito.mock(DomainDescriptor.class);
        Mockito.when((Object)this.classLoader.getArtifactDescriptor()).thenReturn((Object)this.artifactDescriptor);
    }

    @Test
    public void externalConf() throws URISyntaxException {
        File customLogConfig = new File(ClassUtils.getResource((String)"log4j2-test-custom.xml", ((Object)((Object)this)).getClass()).toURI());
        Assert.assertThat((Object)customLogConfig.exists(), (Matcher)CoreMatchers.is((Object)true));
        Mockito.when((Object)this.artifactDescriptor.getLogConfigFile()).thenReturn((Object)customLogConfig);
        MuleLoggerContextFactory loggerCtxFactory = this.spyLoggerContextFactory();
        LoggerContext ctx = loggerCtxFactory.build((ClassLoader)this.classLoader, (ContextSelector)Mockito.mock(ArtifactAwareContextSelector.class), true);
        Assert.assertThat((Object)ctx.getConfigLocation(), (Matcher)CoreMatchers.equalTo((Object)customLogConfig.toURI()));
    }

    @Test
    public void externalConfInvalid() {
        File customLogConfig = new File("src/test/resources/log4j2-test-custom-invalid.xml");
        Assert.assertThat((Object)customLogConfig.exists(), (Matcher)CoreMatchers.is((Object)false));
        Mockito.when((Object)this.artifactDescriptor.getLogConfigFile()).thenReturn((Object)customLogConfig);
        MuleLoggerContextFactory loggerCtxFactory = this.spyLoggerContextFactory();
        LoggerContext ctx = loggerCtxFactory.build((ClassLoader)this.classLoader, (ContextSelector)Mockito.mock(ArtifactAwareContextSelector.class), true);
        Assert.assertThat((Object)ctx.getConfigLocation(), (Matcher)CoreMatchers.equalTo((Object)CONFIG_LOCATION.toURI()));
    }

    @Test
    public void externalConfDomain() throws URISyntaxException {
        Mockito.when((Object)this.classLoader.getArtifactDescriptor()).thenReturn((Object)this.artifactDescriptorDomain);
        File customLogConfig = new File(ClassUtils.getResource((String)"log4j2-test-custom.xml", ((Object)((Object)this)).getClass()).toURI());
        Assert.assertThat((Object)customLogConfig.exists(), (Matcher)CoreMatchers.is((Object)true));
        Mockito.when((Object)this.artifactDescriptorDomain.getLogConfigFile()).thenReturn((Object)customLogConfig);
        MuleLoggerContextFactory loggerCtxFactory = this.spyLoggerContextFactory();
        LoggerContext ctx = loggerCtxFactory.build((ClassLoader)this.classLoader, (ContextSelector)Mockito.mock(ArtifactAwareContextSelector.class), true);
        Assert.assertThat((Object)ctx.getConfigLocation(), (Matcher)CoreMatchers.equalTo((Object)customLogConfig.toURI()));
    }

    @Test
    public void disableLogSeparation() throws URISyntaxException {
        Mockito.when((Object)this.classLoader.getArtifactDescriptor()).thenReturn((Object)this.artifactDescriptorDomain);
        File customLogConfig = new File(ClassUtils.getResource((String)"log4j2-test-custom.xml", ((Object)((Object)this)).getClass()).toURI());
        Assert.assertThat((Object)customLogConfig.exists(), (Matcher)CoreMatchers.is((Object)true));
        Mockito.when((Object)this.artifactDescriptorDomain.getLogConfigFile()).thenReturn((Object)customLogConfig);
        MuleLoggerContextFactory loggerCtxFactory = this.spyLoggerContextFactory();
        LoggerContext ctx = loggerCtxFactory.build((ClassLoader)this.classLoader, (ContextSelector)new SimpleContextSelector(), false);
        Assert.assertThat((Object)ctx.getLogger(((Object)((Object)this)).getClass().getName()), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.instanceOf(DispatchingLogger.class))));
        Assert.assertThat((Object)ctx.getConfigLocation(), (Matcher)CoreMatchers.equalTo((Object)customLogConfig.toURI()));
    }

    protected MuleLoggerContextFactory spyLoggerContextFactory() {
        return (MuleLoggerContextFactory)Mockito.spy((Object)new MuleLoggerContextFactory());
    }
}

