/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.launcher.log4j2;

import java.io.File;
import java.util.ArrayList;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.appender.ConsoleAppender;
import org.apache.logging.log4j.core.appender.RollingFileAppender;
import org.apache.logging.log4j.core.config.AbstractConfiguration;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.ConfigurationFileWatcher;
import org.apache.logging.log4j.core.config.DefaultConfiguration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.config.Reconfigurable;
import org.apache.logging.log4j.core.util.FileWatcher;
import org.apache.logging.log4j.core.util.WatchManager;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptor;
import org.mule.runtime.module.launcher.log4j2.LoggerContextConfigurer;
import org.mule.runtime.module.launcher.log4j2.MuleLoggerContext;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
@RunWith(value=MockitoJUnitRunner.class)
public class LoggerContextConfigurerTestCase
extends AbstractMuleTestCase {
    private static final String CURRENT_DIRECTORY = ".";
    private static final String SHUTDOWN_HOOK_PROPERTY = "isShutdownHookEnabled";
    private static final int MONITOR_INTERVAL = 60000;
    private static final String CONVERTER_COMPONENT = "Converter";
    private static final String FILE_PATTERN_PROPERTY = "filePattern";
    private static final String FILE_PATTERN_TEMPLATE_DATE_SECTION = "%d{yyyy-MM-dd}";
    private LoggerContextConfigurer contextConfigurer;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private MuleLoggerContext context;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS, extraInterfaces={Reconfigurable.class})
    private DefaultConfiguration configuration;
    private Object converter;

    @Before
    public void before() {
        this.contextConfigurer = new LoggerContextConfigurer();
        Mockito.when((Object)this.context.isStandalone()).thenReturn((Object)true);
        Mockito.when((Object)this.context.getConfiguration()).thenReturn((Object)this.configuration);
        this.converter = null;
        ((DefaultConfiguration)Mockito.doAnswer(invocation -> {
            this.converter = invocation.getArguments()[1];
            return null;
        }).when((Object)this.configuration)).addComponent((String)ArgumentMatchers.eq((Object)CONVERTER_COMPONENT), ArgumentMatchers.anyObject());
        Mockito.when((Object)this.configuration.getComponent(CONVERTER_COMPONENT)).thenAnswer(invocation -> this.converter);
    }

    @Test
    public void disableShutdownHook() throws Exception {
        this.contextConfigurer.configure(this.context);
        Assert.assertThat((Object)((Boolean)ClassUtils.getFieldValue((Object)this.context.getConfiguration(), (String)SHUTDOWN_HOOK_PROPERTY, (boolean)true)), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void configurationMonitor() throws Exception {
        WatchManager watchManager = (WatchManager)Mockito.mock(WatchManager.class);
        Mockito.when((Object)this.configuration.getWatchManager()).thenReturn((Object)watchManager);
        Mockito.when((Object)this.context.getConfigFile()).thenReturn((Object)new File(CURRENT_DIRECTORY).toURI());
        this.contextConfigurer.configure(this.context);
        ArgumentCaptor captor = ArgumentCaptor.forClass(ConfigurationFileWatcher.class);
        ((WatchManager)Mockito.verify((Object)watchManager)).watchFile((File)ArgumentMatchers.any(File.class), (FileWatcher)captor.capture());
        Assert.assertThat((Object)captor.getValue(), (Matcher)CoreMatchers.instanceOf(ConfigurationFileWatcher.class));
        ((WatchManager)Mockito.verify((Object)watchManager)).setIntervalSeconds(ArgumentMatchers.eq((int)((int)TimeUnit.MILLISECONDS.toSeconds(60000L))));
    }

    @Test
    public void forceConsoleLog() {
        this.withForceConsoleLog(() -> {
            this.contextConfigurer.update(this.context);
            ArgumentCaptor appenderCaptor = ArgumentCaptor.forClass(ConsoleAppender.class);
            ((Configuration)Mockito.verify((Object)this.context.getConfiguration())).addAppender((Appender)appenderCaptor.capture());
            Appender forcedConsoleAppender = (Appender)appenderCaptor.getValue();
            Assert.assertThat((Object)forcedConsoleAppender, (Matcher)CoreMatchers.notNullValue());
            Assert.assertThat((Object)forcedConsoleAppender.getName(), (Matcher)CoreMatchers.equalTo((Object)"Forced-Console"));
            Assert.assertThat((Object)forcedConsoleAppender.isStarted(), (Matcher)CoreMatchers.is((Object)true));
            LoggerConfig rootLogger = ((AbstractConfiguration)this.context.getConfiguration()).getRootLogger();
            ((LoggerConfig)Mockito.verify((Object)rootLogger)).addAppender(forcedConsoleAppender, Level.ALL, null);
        });
    }

    @Test
    public void perAppDefaultAppender() throws Exception {
        Mockito.when((Object)this.context.isArtifactClassloader()).thenReturn((Object)true);
        Mockito.when((Object)this.context.getArtifactDescriptor().getDeploymentProperties()).thenReturn(Optional.empty());
        this.contextConfigurer.update(this.context);
        ArgumentCaptor appenderCaptor = ArgumentCaptor.forClass(RollingFileAppender.class);
        ((Configuration)Mockito.verify((Object)this.context.getConfiguration())).addAppender((Appender)appenderCaptor.capture());
        Appender perAppAppender = (Appender)appenderCaptor.getValue();
        Assert.assertThat((Object)perAppAppender, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((Object)perAppAppender.getName(), (Matcher)CoreMatchers.equalTo((Object)"defaultFileAppender"));
        Assert.assertThat((Object)perAppAppender.isStarted(), (Matcher)CoreMatchers.is((Object)true));
        String filePattern = (String)ClassUtils.getFieldValue((Object)perAppAppender, (String)FILE_PATTERN_PROPERTY, (boolean)true);
        String filePatternTemplate = filePattern.substring(filePattern.lastIndexOf(47) + 1);
        String filePatternTemplateDateSuffix = filePatternTemplate.substring(filePatternTemplate.lastIndexOf(46) + 1);
        Assert.assertThat((Object)filePatternTemplateDateSuffix, (Matcher)CoreMatchers.equalTo((Object)FILE_PATTERN_TEMPLATE_DATE_SECTION));
        LoggerConfig rootLogger = this.context.getConfiguration().getRootLogger();
        ((LoggerConfig)Mockito.verify((Object)rootLogger)).addAppender(perAppAppender, Level.ALL, null);
    }

    @Test
    public void noAppendersForMutedApplication() throws Exception {
        Mockito.when((Object)this.context.isArtifactClassloader()).thenReturn((Object)true);
        ArtifactDescriptor descriptor = (ArtifactDescriptor)Mockito.mock(ArtifactDescriptor.class);
        Properties properties = new Properties();
        properties.setProperty("mule.application.deployment.muteLog", "true");
        Mockito.when((Object)descriptor.getDeploymentProperties()).thenReturn(Optional.of(properties));
        Mockito.when((Object)this.context.getArtifactDescriptor()).thenReturn((Object)descriptor);
        this.contextConfigurer.update(this.context);
        ((Configuration)Mockito.verify((Object)this.context.getConfiguration(), (VerificationMode)Mockito.never())).addAppender((Appender)ArgumentMatchers.any(Appender.class));
    }

    @Test
    public void forceConsoleLogWithAppenderAlreadyPresent() {
        this.withForceConsoleLog(() -> {
            LoggerConfig rootLogger = ((AbstractConfiguration)this.context.getConfiguration()).getRootLogger();
            ArrayList<ConsoleAppender> appenders = new ArrayList<ConsoleAppender>();
            appenders.add(ConsoleAppender.createAppender((Layout)((Layout)Mockito.mock(Layout.class)), null, null, (String)"Console", null, null));
            Mockito.when(rootLogger.getAppenders().values()).thenReturn(appenders);
            this.contextConfigurer.configure(this.context);
            ((Configuration)Mockito.verify((Object)this.context.getConfiguration(), (VerificationMode)Mockito.never())).addAppender((Appender)ArgumentMatchers.any(ConsoleAppender.class));
            ((LoggerConfig)Mockito.verify((Object)rootLogger, (VerificationMode)Mockito.never())).addAppender((Appender)ArgumentMatchers.any(ConsoleAppender.class), (Level)ArgumentMatchers.same((Object)Level.INFO), (Filter)ArgumentMatchers.any(Filter.class));
        });
    }

    private void withForceConsoleLog(Runnable assertion) {
        System.setProperty("mule.forceConsoleLog", "");
        try {
            assertion.run();
        }
        finally {
            System.clearProperty("mule.forceConsoleLog");
        }
    }
}

