/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.module.launcher;

import static org.hamcrest.Matchers.allOf;
import static org.hamcrest.Matchers.not;
import static org.mockito.ArgumentMatchers.contains;
import static org.mule.runtime.container.api.MuleFoldersUtil.ARTIFACT_PATCHES_FOLDER;
import static org.mule.runtime.core.api.util.FileUtils.newFile;
import static org.mule.tck.junit4.matcher.StringContainsIgnoringLineBreaks.containsStringIgnoringLineBreaks;
import static org.mule.test.allure.AllureConstants.ArtifactPatchingFeature.ARTIFACT_PATCHING;

import io.qameta.allure.Feature;
import io.qameta.allure.Issue;
import java.io.File;
import org.hamcrest.Matcher;
import org.junit.Before;
import org.junit.BeforeClass;
import org.mule.runtime.module.deployment.impl.internal.AbstractSplashScreenTestCase;

@Feature(ARTIFACT_PATCHING)
@Issue("MULE-19416")
public class MuleContainerStartupSplashScreenEmbeddedTestCase
    extends AbstractSplashScreenTestCase<MuleContainerStartupSplashScreen> {

  private static final String FIRST_PATCH = "SE-4242-3.8.0.jar";
  private static final String SECOND_PATCH = "SE-9999-3.7.3.jar";
  private static final String MULE_PATCH = "MULE-1345-4.2.0.jar";
  private static final String LIBRARY_JAR = "library.jar";
  private static final String ARTIFACT_PATCH = "SE-12-1.0.0-1.2.3.jar";
  private static final String APIKIT_PATCH = "APIKIT-12-1.2.0-1.3.0.jar";
  private static final String COMPLEX_LOG_PART = "* Mule services:                                                     *\n"
      + "*  - myService.zip                                                   *\n"
      + "* Applied patches:                                                   *\n"
      + "*  - " + MULE_PATCH + "                                             *\n"
      + "*  - " + FIRST_PATCH + "                                               *\n" + "*  - " + SECOND_PATCH
      + "                                               *\n*  - " + LIBRARY_JAR
      + "                                                     *\n"
      + "* Applied artifact patches:                                          *\n"
      + "*  - " + APIKIT_PATCH + "                                       *\n"
      + "*  - " + ARTIFACT_PATCH + "                                           *\n"
      + "* Mule system properties:                                            *\n";

  @BeforeClass
  public static void setUpPatches() {
    File libFolder = newFile(workingDirectory.getRoot(), "lib/patches");
    libFolder.mkdirs();
    newFile(libFolder, FIRST_PATCH).mkdir();
    newFile(libFolder, "library.jar").mkdir();
    newFile(libFolder, SECOND_PATCH).mkdir();
    newFile(libFolder, MULE_PATCH).mkdir();
    File artifactPatchesFolder = newFile(libFolder, ARTIFACT_PATCHES_FOLDER);
    artifactPatchesFolder.mkdirs();
    newFile(artifactPatchesFolder, ARTIFACT_PATCH).mkdir();
    newFile(artifactPatchesFolder, APIKIT_PATCH).mkdir();
    File servicesFolder = newFile(workingDirectory.getRoot(), "services");
    servicesFolder.mkdir();
    newFile(servicesFolder, "myService.zip").mkdir();
  }

  @Before
  public void setUp() {
    splashScreen = new MuleContainerStartupSplashScreen(true);
  }

  @Override
  protected void setUpSplashScreen() {
    splashScreen.doBody();
  }

  @Override
  protected Matcher<String> getSimpleLogMatcher() {
    return not(containsStringIgnoringLineBreaks(COMPLEX_LOG_PART));
  }

  @Override
  protected Matcher<String> getComplexLogMatcher() {
    return allOf(containsStringIgnoringLineBreaks(COMPLEX_LOG_PART), not(contains("WrapperManager")));
  }
}
