/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.launcher.log4j2;

import java.beans.PropertyChangeListener;
import java.net.URI;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.selector.ContextSelector;
import org.apache.logging.log4j.message.MessageFactory;
import org.mule.runtime.core.internal.logging.LogConfigChangeSubject;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoader;
import org.mule.runtime.module.artifact.api.classloader.RegionClassLoader;
import org.mule.runtime.module.artifact.api.descriptor.ApplicationDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptor;
import org.mule.runtime.module.launcher.log4j2.DispatchingLogger;
import org.mule.runtime.module.launcher.log4j2.LoggerContextConfigurer;

class MuleLoggerContext
extends LoggerContext
implements LogConfigChangeSubject {
    private final LoggerContextConfigurer loggerContextConfigurer = new LoggerContextConfigurer();
    private final URI configFile;
    private final boolean standalone;
    private final boolean logSeparationEnabled;
    private final ContextSelector contextSelector;
    private final boolean artifactClassloader;
    private final boolean applicationClassloader;
    private final String artifactName;
    private final int ownerClassLoaderHash;
    private ArtifactDescriptor artifactDescriptor;

    MuleLoggerContext(String name, ContextSelector contextSelector, boolean standalone, boolean logSeparationEnabled) {
        this(name, null, null, contextSelector, standalone, logSeparationEnabled);
    }

    MuleLoggerContext(String name, URI configLocn, ClassLoader ownerClassLoader, ContextSelector contextSelector, boolean standalone, boolean logSeparationEnabled) {
        super(name, null, configLocn);
        int n;
        this.configFile = configLocn;
        this.contextSelector = contextSelector;
        this.standalone = standalone;
        this.logSeparationEnabled = logSeparationEnabled;
        if (ownerClassLoader != null) {
            n = ownerClassLoader.hashCode();
        } else {
            ((Object)((Object)this)).getClass().getClassLoader();
            n = this.ownerClassLoaderHash = ClassLoader.getSystemClassLoader().hashCode();
        }
        if (ownerClassLoader instanceof ArtifactClassLoader) {
            this.artifactClassloader = true;
            this.artifactName = this.getArtifactName((ArtifactClassLoader)ownerClassLoader);
            this.artifactDescriptor = this.getArtifactDescriptor((ArtifactClassLoader)ownerClassLoader);
            this.applicationClassloader = ownerClassLoader instanceof RegionClassLoader && ((RegionClassLoader)ownerClassLoader).getOwnerClassLoader().getArtifactDescriptor() instanceof ApplicationDescriptor;
        } else {
            this.artifactClassloader = false;
            this.applicationClassloader = false;
            this.artifactName = null;
        }
    }

    private ArtifactDescriptor getArtifactDescriptor(ArtifactClassLoader ownerClassLoader) {
        return ownerClassLoader.getArtifactDescriptor();
    }

    private String getArtifactName(ArtifactClassLoader ownerClassLoader) {
        return ownerClassLoader.getArtifactDescriptor().getName();
    }

    public synchronized void reconfigure() {
        this.loggerContextConfigurer.configure(this);
        if (this.loggerContextConfigurer.shouldConfigureContext(this)) {
            super.reconfigure();
        }
    }

    public void updateLoggers(Configuration config) {
        this.loggerContextConfigurer.update(this);
        super.updateLoggers(config);
    }

    public void registerLogConfigChangeListener(PropertyChangeListener logConfigChangeListener) {
        this.addPropertyChangeListener(logConfigChangeListener);
    }

    public void unregisterLogConfigChangeListener(PropertyChangeListener logConfigChangeListener) {
        this.removePropertyChangeListener(logConfigChangeListener);
    }

    protected Logger newInstance(LoggerContext ctx, String name, MessageFactory messageFactory) {
        Logger logger = super.newInstance(ctx, name, messageFactory);
        if (this.artifactClassloader || this.applicationClassloader || !this.logSeparationEnabled) {
            return logger;
        }
        return new DispatchingLogger(logger, this.ownerClassLoaderHash, this, this.contextSelector, messageFactory){

            public String getName() {
                return this.name;
            }
        };
    }

    protected URI getConfigFile() {
        return this.configFile;
    }

    protected boolean isStandalone() {
        return this.standalone;
    }

    protected boolean isArtifactClassloader() {
        return this.artifactClassloader;
    }

    protected boolean isApplicationClassloader() {
        return this.applicationClassloader;
    }

    protected ArtifactDescriptor getArtifactDescriptor() {
        return this.artifactDescriptor;
    }

    protected String getArtifactName() {
        return this.artifactName;
    }

    public void stop() {
        super.stop();
        this.artifactDescriptor = null;
    }

    public boolean stop(long timeout, TimeUnit timeUnit) {
        boolean result = super.stop(timeout, timeUnit);
        this.artifactDescriptor = null;
        return result;
    }
}

