/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.log4j.internal;

import java.io.File;
import java.net.URISyntaxException;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.selector.ContextSelector;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Answers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnit;
import org.mockito.junit.MockitoRule;
import org.mule.runtime.deployment.model.api.application.ApplicationDescriptor;
import org.mule.runtime.deployment.model.api.domain.DomainDescriptor;
import org.mule.runtime.module.artifact.api.classloader.RegionClassLoader;
import org.mule.runtime.module.log4j.internal.ArtifactAwareContextSelector;
import org.mule.runtime.module.log4j.internal.DispatchingLogger;
import org.mule.runtime.module.log4j.internal.MuleLoggerContextFactory;
import org.mule.runtime.module.log4j.internal.SimpleContextSelector;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
public class MuleLoggerContextFactoryTestCase
extends AbstractMuleTestCase {
    private static final File CONFIG_LOCATION = new File("my/local/log4j2.xml");
    @Rule
    public MockitoRule rule = MockitoJUnit.rule();
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private RegionClassLoader classLoader;
    private ApplicationDescriptor artifactDescriptor;
    private DomainDescriptor artifactDescriptorDomain;

    @Before
    public void before() throws Exception {
        Mockito.when((Object)this.classLoader.getArtifactId()).thenReturn((Object)((Object)((Object)this)).getClass().getName());
        Mockito.when((Object)this.classLoader.findLocalResource("log4j2.xml")).thenReturn((Object)CONFIG_LOCATION.toURI().toURL());
        Mockito.when((Object)this.classLoader.findLocalResource("log4j2-test.xml")).thenReturn(null);
        this.artifactDescriptor = new ApplicationDescriptor("myApp");
        this.artifactDescriptorDomain = new DomainDescriptor("myDomain");
        Mockito.when((Object)this.classLoader.getArtifactDescriptor()).thenReturn((Object)this.artifactDescriptor);
    }

    @Test
    public void externalConf() throws URISyntaxException {
        File customLogConfig = new File(((Object)((Object)this)).getClass().getClassLoader().getResource("log4j2-test-custom.xml").toURI());
        MatcherAssert.assertThat((Object)customLogConfig.exists(), (Matcher)CoreMatchers.is((Object)true));
        this.artifactDescriptor.setLogConfigFile(customLogConfig);
        MuleLoggerContextFactory loggerCtxFactory = this.spyLoggerContextFactory();
        LoggerContext ctx = loggerCtxFactory.build((ClassLoader)this.classLoader, (ContextSelector)Mockito.mock(ArtifactAwareContextSelector.class), true);
        MatcherAssert.assertThat((Object)ctx.getConfigLocation(), (Matcher)CoreMatchers.equalTo((Object)customLogConfig.toURI()));
    }

    @Test
    public void externalConfInvalid() {
        File customLogConfig = new File("src/test/resources/log4j2-test-custom-invalid.xml");
        MatcherAssert.assertThat((Object)customLogConfig.exists(), (Matcher)CoreMatchers.is((Object)false));
        this.artifactDescriptor.setLogConfigFile(customLogConfig);
        MuleLoggerContextFactory loggerCtxFactory = this.spyLoggerContextFactory();
        LoggerContext ctx = loggerCtxFactory.build((ClassLoader)this.classLoader, (ContextSelector)Mockito.mock(ArtifactAwareContextSelector.class), true);
        MatcherAssert.assertThat((Object)ctx.getConfigLocation(), (Matcher)CoreMatchers.equalTo((Object)CONFIG_LOCATION.toURI()));
    }

    @Test
    public void externalConfDomain() throws URISyntaxException {
        Mockito.when((Object)this.classLoader.getArtifactDescriptor()).thenReturn((Object)this.artifactDescriptorDomain);
        File customLogConfig = new File(((Object)((Object)this)).getClass().getClassLoader().getResource("log4j2-test-custom.xml").toURI());
        MatcherAssert.assertThat((Object)customLogConfig.exists(), (Matcher)CoreMatchers.is((Object)true));
        this.artifactDescriptorDomain.setLogConfigFile(customLogConfig);
        MuleLoggerContextFactory loggerCtxFactory = this.spyLoggerContextFactory();
        LoggerContext ctx = loggerCtxFactory.build((ClassLoader)this.classLoader, (ContextSelector)Mockito.mock(ArtifactAwareContextSelector.class), true);
        MatcherAssert.assertThat((Object)ctx.getConfigLocation(), (Matcher)CoreMatchers.equalTo((Object)customLogConfig.toURI()));
    }

    @Test
    public void disableLogSeparation() throws URISyntaxException {
        Mockito.when((Object)this.classLoader.getArtifactDescriptor()).thenReturn((Object)this.artifactDescriptorDomain);
        File customLogConfig = new File(((Object)((Object)this)).getClass().getClassLoader().getResource("log4j2-test-custom.xml").toURI());
        MatcherAssert.assertThat((Object)customLogConfig.exists(), (Matcher)CoreMatchers.is((Object)true));
        this.artifactDescriptorDomain.setLogConfigFile(customLogConfig);
        MuleLoggerContextFactory loggerCtxFactory = this.spyLoggerContextFactory();
        LoggerContext ctx = loggerCtxFactory.build((ClassLoader)this.classLoader, (ContextSelector)new SimpleContextSelector(), false);
        MatcherAssert.assertThat((Object)ctx.getLogger(((Object)((Object)this)).getClass().getName()), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.instanceOf(DispatchingLogger.class))));
        MatcherAssert.assertThat((Object)ctx.getConfigLocation(), (Matcher)CoreMatchers.equalTo((Object)customLogConfig.toURI()));
    }

    protected MuleLoggerContextFactory spyLoggerContextFactory() {
        return (MuleLoggerContextFactory)Mockito.spy((Object)new MuleLoggerContextFactory());
    }
}

