/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.log4j.internal;

import java.util.function.Consumer;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.selector.ContextSelector;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.IsInstanceOf;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junitpioneer.jupiter.SetSystemProperty;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.MockedConstruction;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.module.log4j.boot.api.MuleLog4jContextFactory;
import org.mule.runtime.module.log4j.internal.ApplicationReconfigurableLoggerContextSelector;
import org.mule.runtime.module.log4j.internal.ArtifactAwareContextSelector;
import org.mule.runtime.module.log4j.internal.MuleLog4jConfiguratorUtils;
import org.mule.runtime.module.log4j.internal.MuleLoggerContextFactory;
import org.mule.runtime.module.log4j.internal.SimpleContextSelector;
import org.mule.tck.junit4.AbstractMuleTestCase;

@ExtendWith(value={MockitoExtension.class})
class MuleLog4jConfiguratorUtilsTestCase
extends AbstractMuleTestCase {
    @Mock
    MuleLog4jContextFactory contextFactory;
    @Captor
    ArgumentCaptor<ContextSelector> contextSelectorCapturer;
    @Captor
    ArgumentCaptor<Consumer<ContextSelector>> disposerCapturer;

    MuleLog4jConfiguratorUtilsTestCase() {
    }

    @Test
    void logSeparationWithMultipleApps() {
        MuleLog4jConfiguratorUtils.configureSelector((MuleLog4jContextFactory)this.contextFactory);
        ((MuleLog4jContextFactory)Mockito.verify((Object)this.contextFactory)).setContextSelector((ContextSelector)this.contextSelectorCapturer.capture(), (Consumer)this.disposerCapturer.capture());
        ContextSelector contextSelector = (ContextSelector)this.contextSelectorCapturer.getValue();
        MatcherAssert.assertThat((Object)contextSelector, (Matcher)IsInstanceOf.instanceOf(ArtifactAwareContextSelector.class));
        contextSelector = (ContextSelector)Mockito.spy((Object)contextSelector);
        ((Consumer)this.disposerCapturer.getValue()).accept(contextSelector);
        ((Disposable)Mockito.verify((Object)((Disposable)contextSelector))).dispose();
    }

    @Test
    @SetSystemProperty.SetSystemProperties(value={@SetSystemProperty(key="mule.single.app.mode", value="true"), @SetSystemProperty(key="mule.disableLogSeparation", value="true")})
    void logSeparationDisabled() {
        MuleLog4jConfiguratorUtils.configureSelector((MuleLog4jContextFactory)this.contextFactory);
        ((MuleLog4jContextFactory)Mockito.verify((Object)this.contextFactory)).setContextSelector((ContextSelector)this.contextSelectorCapturer.capture(), (Consumer)this.disposerCapturer.capture());
        ContextSelector contextSelector = (ContextSelector)this.contextSelectorCapturer.getValue();
        MatcherAssert.assertThat((Object)contextSelector, (Matcher)IsInstanceOf.instanceOf(SimpleContextSelector.class));
        ((Consumer)this.disposerCapturer.getValue()).accept(contextSelector);
    }

    @Test
    @SetSystemProperty.SetSystemProperties(value={@SetSystemProperty(key="mule.single.app.mode", value="true"), @SetSystemProperty(key="mule.single.app.mode.container.use.app.log4j.configuration", value="true")})
    void singleApp() {
        LoggerContext loggerContext = (LoggerContext)Mockito.mock(LoggerContext.class);
        LoggerContext appLoggerContext = (LoggerContext)Mockito.mock(LoggerContext.class);
        ClassLoader artifactClassLoader = new ClassLoader(){};
        try (MockedConstruction mockConstruction = Mockito.mockConstruction(MuleLoggerContextFactory.class, (arg_0, arg_1) -> MuleLog4jConfiguratorUtilsTestCase.lambda$singleApp$0(loggerContext, artifactClassLoader, appLoggerContext, arg_0, arg_1));){
            MuleLog4jConfiguratorUtils.configureSelector((MuleLog4jContextFactory)this.contextFactory);
            ((MuleLog4jContextFactory)Mockito.verify((Object)this.contextFactory)).setContextSelector((ContextSelector)this.contextSelectorCapturer.capture(), (Consumer)this.disposerCapturer.capture());
            ContextSelector contextSelector = (ContextSelector)this.contextSelectorCapturer.getValue();
            MatcherAssert.assertThat((Object)contextSelector, (Matcher)IsInstanceOf.instanceOf(ApplicationReconfigurableLoggerContextSelector.class));
            ((Consumer)this.disposerCapturer.getValue()).accept(contextSelector);
            MuleLog4jConfiguratorUtils.getDefaultReconfigurationAction().accept(artifactClassLoader);
            ((LoggerContext)Mockito.verify((Object)loggerContext)).reconfigure();
            ((LoggerContext)Mockito.verify((Object)appLoggerContext)).reconfigure();
        }
    }

    private static /* synthetic */ void lambda$singleApp$0(LoggerContext loggerContext, 1 artifactClassLoader, LoggerContext appLoggerContext, MuleLoggerContextFactory mock, MockedConstruction.Context context) throws Throwable {
        Mockito.when((Object)mock.build((ClassLoader)ArgumentMatchers.eq((Object)ClassLoader.getSystemClassLoader()), (ContextSelector)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean())).thenReturn((Object)loggerContext);
        Mockito.when((Object)mock.build((ClassLoader)ArgumentMatchers.eq((Object)artifactClassLoader), (ContextSelector)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean())).thenReturn((Object)appLoggerContext);
    }
}

