/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.log4j.internal;

import io.qameta.allure.Feature;
import io.qameta.allure.Issue;
import io.qameta.allure.Story;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Stream;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.selector.ContextSelector;
import org.apache.logging.log4j.message.MessageFactory;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.Answers;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.mule.runtime.api.util.concurrent.Latch;
import org.mule.runtime.core.internal.util.ClassUtils;
import org.mule.runtime.module.artifact.api.classloader.NonBlockingLoggerResolutionClassRegistry;
import org.mule.runtime.module.artifact.api.classloader.RegionClassLoader;
import org.mule.runtime.module.log4j.internal.ArtifactAwareContextSelector;
import org.mule.runtime.module.log4j.internal.DispatchingLogger;
import org.mule.runtime.module.log4j.internal.LoggerContextCache;
import org.mule.runtime.module.log4j.internal.RecursiveLoggerContextInstantiationException;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.probe.JUnitLambdaProbe;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;
import org.mule.tck.size.SmallTest;

@SmallTest
@ExtendWith(value={MockitoExtension.class})
@Feature(value="Logging")
@Story(value="Log Context Factory")
public class DispatchingLoggerTestCase
extends AbstractMuleTestCase {
    private static final String LOGGER_NAME = DispatchingLoggerTestCase.class.getName();
    private static final String MESSAGE = "Hello Log!";
    private static final long PROBER_POLLING_TIMEOUT = 5000L;
    private static final long PROBER_POLLING_INTERVAL = 100L;
    private ClassLoader currentClassLoader;
    @Mock
    private ClassLoader additionalClassLoader;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private Logger originalLogger;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private LoggerContext containerLoggerContext;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private ContextSelector contextSelector;
    @Mock
    private ArtifactAwareContextSelector artifactAwareContextSelector;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private MessageFactory messageFactory;
    @Mock
    RegionClassLoader regionClassLoader;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    LoggerContext regionClassLoaderLoggerContext;
    private Logger logger;
    private LoggerContextCache loggerContextCache;

    @BeforeEach
    public void before() {
        this.currentClassLoader = Thread.currentThread().getContextClassLoader();
        Mockito.when((Object)this.containerLoggerContext.getConfiguration().getLoggerConfig(ArgumentMatchers.anyString()).getLevel()).thenReturn((Object)Level.INFO);
        this.logger = new DispatchingLogger(this.originalLogger, this.currentClassLoader.hashCode(), this.containerLoggerContext, this.contextSelector, this.messageFactory){

            public String getName() {
                return LOGGER_NAME;
            }
        };
        this.loggerContextCache = (LoggerContextCache)Mockito.spy((Object)new LoggerContextCache(this.artifactAwareContextSelector, (ClassLoader)Mockito.mock(ClassLoader.class, (Answer)Answers.RETURNS_DEEP_STUBS)));
    }

    @AfterEach
    public void after() {
        this.loggerContextCache.dispose();
    }

    @Test
    @Issue(value="W-18388443")
    void noParallelizationWhenGettingLoggerFirstForClassNeedingBlockingAndThenForRegularClass() throws Exception {
        Logger regionClassLoaderLogger = this.getRegionClassLoader();
        Latch blockingContextLatch = new Latch();
        AtomicBoolean blockingLoggerInContext = new AtomicBoolean(false);
        AtomicBoolean nonBlockingLoggerInContext = new AtomicBoolean(false);
        ClassOwningLoggerNeedingBlocking blockingLoggerOwner = new ClassOwningLoggerNeedingBlocking();
        ClassOwningLogger nonBlockingLoggerOwner = new ClassOwningLogger();
        DispatchingLogger blockingLogger = blockingLoggerOwner.getDispatchingLogger();
        DispatchingLogger nonBlockingLogger = nonBlockingLoggerOwner.getDispatchingLogger();
        String log1 = "Log 1";
        String log2 = "Log 2";
        Thread blockingLogThread = new Thread(() -> blockingLogger.info(log1));
        Thread nonBlockingLogThread = new Thread(() -> nonBlockingLogger.info(log2));
        ((LoggerContextCache)Mockito.doAnswer(invocation -> {
            boolean isBlockingLogger;
            boolean bl = isBlockingLogger = Thread.currentThread() == blockingLogThread;
            if (isBlockingLogger) {
                blockingLoggerInContext.set(true);
                try {
                    blockingContextLatch.await(1000L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            } else {
                nonBlockingLoggerInContext.set(true);
                blockingContextLatch.countDown();
            }
            return this.regionClassLoaderLoggerContext;
        }).when((Object)this.loggerContextCache)).doGetLoggerContext((ClassLoader)ArgumentMatchers.eq((Object)this.regionClassLoader), (Integer)ArgumentMatchers.any());
        blockingLogThread.setContextClassLoader((ClassLoader)this.regionClassLoader);
        nonBlockingLogThread.setContextClassLoader((ClassLoader)this.regionClassLoader);
        blockingLogThread.start();
        new PollingProber(5000L, 100L).check((Probe)new JUnitLambdaProbe(() -> {
            MatcherAssert.assertThat((Object)blockingLoggerInContext.get(), (Matcher)CoreMatchers.is((Object)true));
            return true;
        }));
        nonBlockingLogThread.start();
        new PollingProber(5000L, 100L).check((Probe)new JUnitLambdaProbe(() -> {
            MatcherAssert.assertThat((Object)nonBlockingLoggerInContext.get(), (Matcher)CoreMatchers.is((Object)true));
            return true;
        }));
        new PollingProber(5000L, 100L).check((Probe)new JUnitLambdaProbe(() -> {
            ((Logger)Mockito.verify((Object)regionClassLoaderLogger, (VerificationMode)Mockito.times((int)2))).info(ArgumentMatchers.anyString());
            return true;
        }));
        blockingLogThread.join();
        nonBlockingLogThread.join();
    }

    @Test
    @Issue(value="W-18388443")
    void noParallelizationWhenGettingLoggerFirstForRegularClassAndThenForClassNeedingBlocking() throws Exception {
        Logger regionClassLoaderLogger = this.getRegionClassLoader();
        Latch nonBlockingContextLatch = new Latch();
        AtomicBoolean nonBlockingLoggerInContext = new AtomicBoolean(false);
        AtomicBoolean blockingLoggerInContext = new AtomicBoolean(false);
        ClassOwningLogger nonBlockingLoggerOwner = new ClassOwningLogger();
        ClassOwningLoggerNeedingBlocking blockingLoggerOwner = new ClassOwningLoggerNeedingBlocking();
        DispatchingLogger nonBlockingLogger = nonBlockingLoggerOwner.getDispatchingLogger();
        DispatchingLogger blockingLogger = blockingLoggerOwner.getDispatchingLogger();
        String log1 = "Log 1";
        String log2 = "Log 2";
        Thread nonBlockingLogThread = new Thread(() -> nonBlockingLogger.info(log1));
        Thread blockingLogThread = new Thread(() -> blockingLogger.info(log2));
        ((LoggerContextCache)Mockito.doAnswer(invocation -> {
            boolean isBlockingLogger;
            boolean bl = isBlockingLogger = Thread.currentThread() == blockingLogThread;
            if (isBlockingLogger) {
                blockingLoggerInContext.set(true);
                nonBlockingContextLatch.countDown();
            } else {
                nonBlockingLoggerInContext.set(true);
                try {
                    nonBlockingContextLatch.await(1000L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            return this.regionClassLoaderLoggerContext;
        }).when((Object)this.loggerContextCache)).doGetLoggerContext((ClassLoader)ArgumentMatchers.eq((Object)this.regionClassLoader), (Integer)ArgumentMatchers.any());
        nonBlockingLogThread.setContextClassLoader((ClassLoader)this.regionClassLoader);
        blockingLogThread.setContextClassLoader((ClassLoader)this.regionClassLoader);
        nonBlockingLogThread.start();
        new PollingProber(5000L, 100L).check((Probe)new JUnitLambdaProbe(() -> {
            MatcherAssert.assertThat((Object)nonBlockingLoggerInContext.get(), (Matcher)CoreMatchers.is((Object)true));
            return true;
        }));
        blockingLogThread.start();
        new PollingProber(5000L, 100L).check((Probe)new JUnitLambdaProbe(() -> {
            MatcherAssert.assertThat((Object)blockingLoggerInContext.get(), (Matcher)CoreMatchers.is((Object)true));
            return true;
        }));
        new PollingProber(5000L, 100L).check((Probe)new JUnitLambdaProbe(() -> {
            ((Logger)Mockito.verify((Object)regionClassLoaderLogger, (VerificationMode)Mockito.times((int)2))).info(ArgumentMatchers.anyString());
            return true;
        }));
        nonBlockingLogThread.join();
        blockingLogThread.join();
    }

    private Logger getRegionClassLoader() throws ExecutionException {
        Logger containerLogger = (Logger)Mockito.mock(Logger.class);
        Logger regionClassLoaderLogger = (Logger)Mockito.mock(Logger.class);
        Mockito.when((Object)this.containerLoggerContext.getLogger(ArgumentMatchers.anyString(), (MessageFactory)ArgumentMatchers.any(MessageFactory.class))).thenReturn((Object)containerLogger);
        Mockito.when((Object)this.regionClassLoaderLoggerContext.getLogger(ArgumentMatchers.anyString(), (MessageFactory)ArgumentMatchers.any(MessageFactory.class))).thenReturn((Object)regionClassLoaderLogger);
        Mockito.when((Object)this.artifactAwareContextSelector.getContextWithResolvedContextClassLoader((ClassLoader)ArgumentMatchers.any())).thenAnswer(invocation -> this.loggerContextCache.getLoggerContext((ClassLoader)invocation.getArgument(0)));
        Mockito.lenient().when((Object)this.artifactAwareContextSelector.getLoggerContextCache()).thenReturn((Object)this.loggerContextCache);
        ((LoggerContextCache)Mockito.lenient().doAnswer(invocationOnMock -> this.containerLoggerContext).when((Object)this.loggerContextCache)).doGetLoggerContext((ClassLoader)ArgumentMatchers.eq((Object)this.currentClassLoader), (Integer)ArgumentMatchers.any());
        return regionClassLoaderLogger;
    }

    @Test
    void currentClassLoader() {
        this.logger.info(MESSAGE);
        ((Logger)Mockito.verify((Object)this.originalLogger)).info(MESSAGE);
    }

    @Test
    void anotherClassLoader() {
        ClassUtils.withContextClassLoader((ClassLoader)this.additionalClassLoader, () -> {
            this.logger.info(MESSAGE);
            ((Logger)Mockito.verify((Object)this.originalLogger)).info(MESSAGE);
        });
    }

    @Test
    void regionClassLoader() {
        RegionClassLoader regionClassLoader = (RegionClassLoader)Mockito.mock(RegionClassLoader.class);
        ClassUtils.withContextClassLoader((ClassLoader)regionClassLoader, () -> {
            this.logger.info(MESSAGE);
            ((ContextSelector)Mockito.verify((Object)this.contextSelector)).getContext(LOGGER_NAME, (ClassLoader)regionClassLoader, true);
        });
    }

    @Test
    void whenRecursiveLoggerContextInstantiationExceptionExpectFallbackUsingContainerClassLoader() {
        Logger containerLogger = (Logger)Mockito.mock(Logger.class);
        Logger regionClassLoaderLogger = (Logger)Mockito.mock(Logger.class);
        Mockito.when((Object)this.containerLoggerContext.getLogger(ArgumentMatchers.anyString(), (MessageFactory)ArgumentMatchers.any(MessageFactory.class))).thenReturn((Object)containerLogger);
        Mockito.when((Object)this.regionClassLoaderLoggerContext.getLogger(ArgumentMatchers.anyString(), (MessageFactory)ArgumentMatchers.any(MessageFactory.class))).thenReturn((Object)regionClassLoaderLogger);
        Mockito.when((Object)this.artifactAwareContextSelector.getContextWithResolvedContextClassLoader(this.currentClassLoader)).thenAnswer(invocation -> this.containerLoggerContext);
        Mockito.when((Object)this.artifactAwareContextSelector.getContextWithResolvedContextClassLoader((ClassLoader)this.regionClassLoader)).thenThrow(RecursiveLoggerContextInstantiationException.class).thenAnswer(invocation -> this.regionClassLoaderLoggerContext);
        DispatchingLogger dispatchingLogger = new DispatchingLogger(this.originalLogger, this.currentClassLoader.hashCode(), this.containerLoggerContext, (ContextSelector)this.artifactAwareContextSelector, this.messageFactory){

            public String getName() {
                return LOGGER_NAME;
            }
        };
        ClassUtils.withContextClassLoader((ClassLoader)this.regionClassLoader, () -> {
            dispatchingLogger.info("Fallback Test Message");
            dispatchingLogger.info("Test Message");
        });
        ((Logger)Mockito.verify((Object)containerLogger, (VerificationMode)Mockito.times((int)1))).info("Fallback Test Message");
        ((Logger)Mockito.verify((Object)regionClassLoaderLogger, (VerificationMode)Mockito.times((int)1))).info("Test Message");
    }

    @Test
    void whenFallbackToContainerClassLoaderFailsReturnOriginalLogger() {
        Logger containerLogger = (Logger)Mockito.mock(Logger.class);
        Logger regionClassLoaderLogger = (Logger)Mockito.mock(Logger.class);
        Mockito.when((Object)this.containerLoggerContext.getLogger(ArgumentMatchers.anyString(), (MessageFactory)ArgumentMatchers.any(MessageFactory.class))).thenReturn((Object)containerLogger);
        Mockito.when((Object)this.regionClassLoaderLoggerContext.getLogger(ArgumentMatchers.anyString(), (MessageFactory)ArgumentMatchers.any(MessageFactory.class))).thenReturn((Object)regionClassLoaderLogger);
        Mockito.when((Object)this.artifactAwareContextSelector.getContextWithResolvedContextClassLoader(this.currentClassLoader)).thenThrow(RecursiveLoggerContextInstantiationException.class).thenAnswer(invocation -> this.containerLoggerContext);
        Mockito.when((Object)this.artifactAwareContextSelector.getContextWithResolvedContextClassLoader((ClassLoader)this.regionClassLoader)).thenThrow(RecursiveLoggerContextInstantiationException.class).thenAnswer(invocation -> this.regionClassLoaderLoggerContext);
        DispatchingLogger dispatchingLogger = new DispatchingLogger(this.originalLogger, this.currentClassLoader.hashCode(), this.containerLoggerContext, (ContextSelector)this.artifactAwareContextSelector, this.messageFactory){

            public String getName() {
                return LOGGER_NAME;
            }
        };
        ClassUtils.withContextClassLoader((ClassLoader)this.regionClassLoader, () -> {
            dispatchingLogger.info("Fallback Test Message");
            dispatchingLogger.info("Test Message");
        });
        ((Logger)Mockito.verify((Object)this.originalLogger, (VerificationMode)Mockito.times((int)1))).info("Fallback Test Message");
        ((Logger)Mockito.verify((Object)regionClassLoaderLogger, (VerificationMode)Mockito.times((int)1))).info("Test Message");
    }

    static Stream<Method> log4jOverridableMethods() {
        Class<Logger> log4jLoggerClass = Logger.class;
        HashSet<String> nonLog4jSignatures = new HashSet<String>();
        Stream.of(Object.class.getDeclaredMethods()).map(DispatchingLoggerTestCase::signature).forEach(nonLog4jSignatures::add);
        DispatchingLoggerTestCase.collectNonLog4jMethodSignatures(log4jLoggerClass, nonLog4jSignatures);
        return Stream.of(log4jLoggerClass.getMethods()).filter(m -> m.getDeclaringClass().getPackageName().startsWith("org.apache.logging.log4j")).filter(m -> Modifier.isPublic(m.getModifiers()) && !Modifier.isFinal(m.getModifiers()) && !Modifier.isStatic(m.getModifiers())).filter(m -> !nonLog4jSignatures.contains(DispatchingLoggerTestCase.signature(m))).filter(m -> !m.getName().equals("getName")).distinct();
    }

    private static void collectNonLog4jMethodSignatures(Class<?> type, Set<String> signatures) {
        if (type == null || type == Object.class) {
            return;
        }
        if (!type.getPackageName().startsWith("org.apache.logging.log4j")) {
            Stream.of(type.getDeclaredMethods()).map(DispatchingLoggerTestCase::signature).forEach(signatures::add);
        }
        for (Class<?> iface : type.getInterfaces()) {
            DispatchingLoggerTestCase.collectNonLog4jMethodSignatures(iface, signatures);
        }
        DispatchingLoggerTestCase.collectNonLog4jMethodSignatures(type.getSuperclass(), signatures);
    }

    private static String signature(Method m) {
        return m.getName() + Arrays.toString(m.getParameterTypes());
    }

    public static boolean isOverridden(Method method, Method superMethod) {
        return superMethod.getName().equals(method.getName()) && Arrays.equals(superMethod.getParameterTypes(), method.getParameterTypes()) && superMethod.getReturnType().isAssignableFrom(method.getReturnType());
    }

    @Issue(value="W-10622326")
    @ParameterizedTest
    @MethodSource(value={"log4jOverridableMethods"})
    void properLog4jDelegation(Method overridableMethod) throws IllegalAccessException, InvocationTargetException {
        Object[] params = Stream.of(overridableMethod.getParameterTypes()).map(p -> {
            if (p.isPrimitive()) {
                if (p.equals(Boolean.TYPE)) {
                    return true;
                }
            } else {
                if (p.isArray()) {
                    return Array.newInstance(p.getComponentType(), 0);
                }
                if (p.equals(Object.class)) {
                    return new Object();
                }
                if (p.equals(String.class)) {
                    return "string";
                }
            }
            return Mockito.mock((Class)p);
        }).toArray();
        overridableMethod.invoke((Object)this.logger, params);
        overridableMethod.invoke(Mockito.verify((Object)this.originalLogger), params);
    }

    private class ClassOwningLoggerNeedingBlocking
    extends ClassOwningLogger {
        private ClassOwningLoggerNeedingBlocking() {
        }

        static {
            NonBlockingLoggerResolutionClassRegistry.getNonBlockingLoggerResolutionClassRegistry().registerClassNeedingNonBlockingLoggerResolution(ClassOwningLoggerNeedingBlocking.class);
        }
    }

    private class ClassOwningLogger {
        private final Logger logger = this.getLogger();

        private ClassOwningLogger() {
        }

        private Logger getLogger() {
            Logger logger = (Logger)Mockito.mock(Logger.class, (Answer)Answers.RETURNS_DEEP_STUBS);
            Mockito.when((Object)logger.getName()).thenReturn((Object)this.getClass().getName());
            return logger;
        }

        public DispatchingLogger getDispatchingLogger() {
            return (DispatchingLogger)Mockito.spy((Object)new DispatchingLogger(this.logger, DispatchingLoggerTestCase.this.currentClassLoader.hashCode(), DispatchingLoggerTestCase.this.containerLoggerContext, (ContextSelector)DispatchingLoggerTestCase.this.artifactAwareContextSelector, DispatchingLoggerTestCase.this.messageFactory){

                public String getName() {
                    return LOGGER_NAME;
                }
            });
        }
    }
}

