/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.log4j.internal;

import io.qameta.allure.Description;
import io.qameta.allure.Issue;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.async.AsyncLoggerConfig;
import org.apache.logging.log4j.core.config.AppenderRef;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.selector.ContextSelector;
import org.apache.logging.log4j.message.MessageFactory;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsInstanceOf;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.junit.MockitoJUnit;
import org.mockito.junit.MockitoRule;
import org.mule.functional.logging.TestAppender;
import org.mule.runtime.module.log4j.internal.DispatchingLogger;
import org.mule.runtime.module.log4j.internal.MuleLoggerContext;
import org.mule.runtime.module.log4j.internal.SimpleContextSelector;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.junit4.matcher.Eventually;
import org.mule.tck.probe.JUnitProbe;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;
import org.mule.tck.size.SmallTest;
import org.mule.tck.util.CollectableReference;

@SmallTest
public class MuleLoggerContextTestCase
extends AbstractMuleTestCase {
    private static final String DEFAULT_CONTEXT_NAME = "Default";
    private static final String MESSAGE = "Do you wanna build a snowman?";
    private static final String CATEGORY = MuleLoggerContextTestCase.class.getName();
    private static final String TEST_APPENDER = "testAppender";
    private static final Level LEVEL = Level.ERROR;
    @Rule
    public MockitoRule rule = MockitoJUnit.rule();
    @Mock
    private ContextSelector contextSelector;
    @Mock
    private MessageFactory messageFactory;
    private MuleLoggerContext context;
    private TestAppender testAppender;

    @Before
    public void before() {
        this.context = this.getDefaultContext(true);
        this.testAppender = new TestAppender(TEST_APPENDER, null, null);
        this.addTestAppender(this.context, (Appender)this.testAppender);
    }

    @Test
    public void dispatchingLogger() {
        Assert.assertThat((Object)this.context.newInstance((LoggerContext)this.context, "", this.messageFactory), (Matcher)IsInstanceOf.instanceOf(DispatchingLogger.class));
    }

    @Test
    public void disableLogSeparation() {
        this.context = this.getDefaultContext(false);
        this.addTestAppender(this.context, (Appender)this.testAppender);
        Assert.assertThat((Object)this.context.newInstance((LoggerContext)this.context, "", this.messageFactory), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)IsInstanceOf.instanceOf(DispatchingLogger.class))));
        this.reconfigureAsyncLoggers();
    }

    @Test
    public void reconfigureAsyncLoggers() {
        Logger logger = this.context.getLogger(CATEGORY);
        logger.error(MESSAGE);
        this.assertLogged();
        this.testAppender.clear();
        this.context.updateLoggers(this.context.getConfiguration());
        logger.error(MESSAGE);
        this.assertLogged();
    }

    @Test
    @Issue(value="W-11698561")
    @Description(value="The MuleLoggerContext does not keep a reference to a ContextSelector which could cause a MuleArtifactClassLoader leak.")
    public void contextDoesNotLeakContextSelectorAfterStop() {
        this.contextSelector = new SimpleContextSelector();
        this.context = this.getDefaultContext(true);
        CollectableReference collectableReference = new CollectableReference((Object)this.contextSelector);
        this.contextSelector = null;
        this.context.stop();
        Assert.assertThat((Object)collectableReference, (Matcher)CoreMatchers.is((Matcher)Eventually.eventually((Matcher)CollectableReference.collectedByGc())));
    }

    private void assertLogged() {
        PollingProber pollingProber = new PollingProber(5000L, 500L);
        pollingProber.check((Probe)new JUnitProbe(){

            protected boolean test() throws Exception {
                MuleLoggerContextTestCase.this.testAppender.ensure(new TestAppender.Expectation[]{new TestAppender.Expectation(LEVEL.name(), CATEGORY, MuleLoggerContextTestCase.MESSAGE)});
                return true;
            }

            public String describeFailure() {
                return "message was not logged";
            }
        });
    }

    private MuleLoggerContext getDefaultContext(boolean logSeparationEnabled) {
        return new MuleLoggerContext(DEFAULT_CONTEXT_NAME, null, Thread.currentThread().getContextClassLoader(), this.contextSelector, true, logSeparationEnabled);
    }

    private void addTestAppender(MuleLoggerContext context, Appender testAppender) {
        context.getConfiguration().addAppender(testAppender);
        LoggerConfig loggerConfig = AsyncLoggerConfig.createLogger((String)"false", (String)LEVEL.name(), (String)CATEGORY, (String)"true", (AppenderRef[])new AppenderRef[]{AppenderRef.createAppenderRef((String)TEST_APPENDER, null, null)}, null, (Configuration)context.getConfiguration(), null);
        loggerConfig.addAppender(testAppender, null, null);
        context.getConfiguration().addLogger(CATEGORY, loggerConfig);
        context.getConfiguration().start();
        context.updateLoggers();
    }
}

