/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.log4j.internal;

import io.qameta.allure.Feature;
import io.qameta.allure.Issue;
import io.qameta.allure.Story;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.selector.ContextSelector;
import org.apache.logging.log4j.message.MessageFactory;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Answers;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnit;
import org.mockito.junit.MockitoRule;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.api.util.concurrent.Latch;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.module.artifact.api.classloader.BlockingLoggerResolutionClassRegistry;
import org.mule.runtime.module.artifact.api.classloader.RegionClassLoader;
import org.mule.runtime.module.log4j.internal.ArtifactAwareContextSelector;
import org.mule.runtime.module.log4j.internal.DispatchingLogger;
import org.mule.runtime.module.log4j.internal.LoggerContextCache;
import org.mule.runtime.module.log4j.internal.RecursiveLoggerContextInstantiationException;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.probe.JUnitLambdaProbe;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;
import org.mule.tck.size.SmallTest;

@SmallTest
@Feature(value="Logging")
@Story(value="Log Context Factory")
public class DispatchingLoggerTestCase
extends AbstractMuleTestCase {
    private static final String LOGGER_NAME = DispatchingLoggerTestCase.class.getName();
    private static final String MESSAGE = "Hello Log!";
    private static final long PROBER_POLLING_TIMEOUT = 5000L;
    private static final long PROBER_POLLING_INTERVAL = 100L;
    @Rule
    public MockitoRule rule = MockitoJUnit.rule();
    private ClassLoader currentClassLoader;
    @Mock
    private ClassLoader additionalClassLoader;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private Logger originalLogger;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private LoggerContext containerLoggerContext;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private ContextSelector contextSelector;
    @Mock
    private ArtifactAwareContextSelector artifactAwareContextSelector;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private MessageFactory messageFactory;
    @Mock
    RegionClassLoader regionClassLoader;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    LoggerContext regionClassLoaderLoggerContext;
    private Logger logger;
    private LoggerContextCache loggerContextCache;

    @Before
    public void before() {
        this.currentClassLoader = Thread.currentThread().getContextClassLoader();
        Mockito.when((Object)this.containerLoggerContext.getConfiguration().getLoggerConfig(ArgumentMatchers.anyString()).getLevel()).thenReturn((Object)Level.INFO);
        this.logger = new DispatchingLogger(this.originalLogger, this.currentClassLoader.hashCode(), this.containerLoggerContext, this.contextSelector, this.messageFactory){

            public String getName() {
                return LOGGER_NAME;
            }
        };
        this.loggerContextCache = (LoggerContextCache)Mockito.spy((Object)new LoggerContextCache(this.artifactAwareContextSelector, (ClassLoader)Mockito.mock(ClassLoader.class, (Answer)Answers.RETURNS_DEEP_STUBS)));
    }

    @After
    public void after() {
        this.loggerContextCache.dispose();
    }

    @Test
    @Issue(value="W-18388443")
    public void noParallelizationWhenGettingLoggerFirstForClassNeedingBlockingAndThenForRegularClass() throws Exception {
        Logger regionClassLoaderLogger = this.getRegionClassLoader();
        Latch latch = new Latch();
        AtomicInteger getLoggerContextTimesCalled = new AtomicInteger(0);
        AtomicBoolean getLoggerBlockingCalled = new AtomicBoolean(false);
        AtomicBoolean getLoggerNonBlockingCalled = new AtomicBoolean(false);
        ClassOwningLoggerNeedingBlocking blockingLoggerOwner = new ClassOwningLoggerNeedingBlocking();
        ClassOwningLogger nonBlockingLoggerOwner = new ClassOwningLogger();
        DispatchingLogger blockingLogger = blockingLoggerOwner.getDispatchingLogger();
        DispatchingLogger nonBlockingLogger = nonBlockingLoggerOwner.getDispatchingLogger();
        ((DispatchingLogger)Mockito.doAnswer(invocation -> {
            MatcherAssert.assertThat((Object)getLoggerBlockingCalled.compareAndSet(false, true), (Matcher)CoreMatchers.is((Object)true));
            MatcherAssert.assertThat((Object)latch.await(1000L, TimeUnit.MILLISECONDS), (Matcher)CoreMatchers.is((Object)true));
            return invocation.callRealMethod();
        }).when((Object)blockingLogger)).getLogger((ClassLoader)ArgumentMatchers.any(ClassLoader.class), (Reference)ArgumentMatchers.any(Reference.class));
        ((DispatchingLogger)Mockito.doAnswer(invocation -> {
            MatcherAssert.assertThat((Object)getLoggerNonBlockingCalled.compareAndSet(false, true), (Matcher)CoreMatchers.is((Object)true));
            return invocation.callRealMethod();
        }).when((Object)nonBlockingLogger)).getLogger((ClassLoader)ArgumentMatchers.any(ClassLoader.class), (Reference)ArgumentMatchers.any(Reference.class));
        ((LoggerContextCache)Mockito.doAnswer(invocation -> {
            getLoggerContextTimesCalled.incrementAndGet();
            return this.regionClassLoaderLoggerContext;
        }).when((Object)this.loggerContextCache)).doGetLoggerContext((ClassLoader)ArgumentMatchers.eq((Object)this.regionClassLoader), (Integer)ArgumentMatchers.any());
        String log1 = "Log 1";
        String log2 = "Log 2";
        Thread blockingLogThread = new Thread(() -> blockingLogger.info(log1));
        Thread nonBlockingLogThread = new Thread(() -> nonBlockingLogger.info(log2));
        blockingLogThread.setContextClassLoader((ClassLoader)this.regionClassLoader);
        nonBlockingLogThread.setContextClassLoader((ClassLoader)this.regionClassLoader);
        blockingLogThread.start();
        new PollingProber(5000L, 100L).check((Probe)new JUnitLambdaProbe(() -> {
            MatcherAssert.assertThat((Object)getLoggerBlockingCalled.get(), (Matcher)CoreMatchers.is((Object)true));
            return true;
        }));
        ((Logger)Mockito.verify((Object)regionClassLoaderLogger, (VerificationMode)Mockito.times((int)0))).info(log1);
        ((Logger)Mockito.verify((Object)regionClassLoaderLogger, (VerificationMode)Mockito.times((int)0))).info(log2);
        nonBlockingLogThread.start();
        new PollingProber(5000L, 100L).check((Probe)new JUnitLambdaProbe(() -> {
            MatcherAssert.assertThat((Object)getLoggerNonBlockingCalled.get(), (Matcher)CoreMatchers.is((Object)true));
            return true;
        }));
        Thread.sleep(200L);
        MatcherAssert.assertThat((Object)getLoggerContextTimesCalled.get(), (Matcher)CoreMatchers.is((Object)0));
        latch.countDown();
        new PollingProber(5000L, 100L).check((Probe)new JUnitLambdaProbe(() -> {
            ((Logger)Mockito.verify((Object)regionClassLoaderLogger, (VerificationMode)Mockito.times((int)1))).info(log1);
            return true;
        }));
        new PollingProber(5000L, 100L).check((Probe)new JUnitLambdaProbe(() -> {
            MatcherAssert.assertThat((Object)getLoggerContextTimesCalled.get(), (Matcher)CoreMatchers.is((Object)2));
            return true;
        }));
        new PollingProber(5000L, 100L).check((Probe)new JUnitLambdaProbe(() -> {
            ((Logger)Mockito.verify((Object)regionClassLoaderLogger, (VerificationMode)Mockito.times((int)1))).info(log2);
            return true;
        }));
        blockingLogThread.join();
        nonBlockingLogThread.join();
    }

    @Test
    @Issue(value="W-18388443")
    public void noParallelizationWhenGettingLoggerFirstForRegularClassAndThenForClassNeedingBlocking() throws Exception {
        Logger regionClassLoaderLogger = this.getRegionClassLoader();
        Latch latch = new Latch();
        AtomicInteger getLoggerContextTimesCalled = new AtomicInteger(0);
        AtomicBoolean getLoggerBlockingCalled = new AtomicBoolean(false);
        ClassOwningLogger nonBlockingLoggerOwner = new ClassOwningLogger();
        ClassOwningLoggerNeedingBlocking blockingLoggerOwner = new ClassOwningLoggerNeedingBlocking();
        DispatchingLogger nonBlockingLogger = nonBlockingLoggerOwner.getDispatchingLogger();
        DispatchingLogger blockingLogger = blockingLoggerOwner.getDispatchingLogger();
        ((LoggerContextCache)Mockito.doAnswer(invocation -> {
            if (getLoggerContextTimesCalled.incrementAndGet() == 1) {
                MatcherAssert.assertThat((Object)latch.await(1000L, TimeUnit.MILLISECONDS), (Matcher)CoreMatchers.is((Object)true));
            }
            return this.regionClassLoaderLoggerContext;
        }).when((Object)this.loggerContextCache)).doGetLoggerContext((ClassLoader)ArgumentMatchers.eq((Object)this.regionClassLoader), (Integer)ArgumentMatchers.any());
        ((DispatchingLogger)Mockito.doAnswer(invocation -> {
            MatcherAssert.assertThat((Object)getLoggerBlockingCalled.compareAndSet(false, true), (Matcher)CoreMatchers.is((Object)true));
            return invocation.callRealMethod();
        }).when((Object)blockingLogger)).getLogger((ClassLoader)ArgumentMatchers.any(ClassLoader.class), (Reference)ArgumentMatchers.any(Reference.class));
        String log1 = "Log 1";
        String log2 = "Log 2";
        Thread nonBlockingLogThread = new Thread(() -> nonBlockingLogger.info(log1));
        Thread blockingLogThread = new Thread(() -> blockingLogger.info(log2));
        nonBlockingLogThread.setContextClassLoader((ClassLoader)this.regionClassLoader);
        blockingLogThread.setContextClassLoader((ClassLoader)this.regionClassLoader);
        nonBlockingLogThread.start();
        new PollingProber(5000L, 100L).check((Probe)new JUnitLambdaProbe(() -> {
            MatcherAssert.assertThat((Object)getLoggerContextTimesCalled.get(), (Matcher)CoreMatchers.is((Object)1));
            return true;
        }));
        ((Logger)Mockito.verify((Object)regionClassLoaderLogger, (VerificationMode)Mockito.times((int)0))).info(log1);
        ((Logger)Mockito.verify((Object)regionClassLoaderLogger, (VerificationMode)Mockito.times((int)0))).info(log2);
        blockingLogThread.start();
        Thread.sleep(200L);
        MatcherAssert.assertThat((Object)getLoggerBlockingCalled.get(), (Matcher)CoreMatchers.is((Object)false));
        latch.countDown();
        new PollingProber(5000L, 100L).check((Probe)new JUnitLambdaProbe(() -> {
            ((Logger)Mockito.verify((Object)regionClassLoaderLogger, (VerificationMode)Mockito.times((int)1))).info(log1);
            return true;
        }));
        new PollingProber(5000L, 100L).check((Probe)new JUnitLambdaProbe(() -> {
            MatcherAssert.assertThat((Object)getLoggerBlockingCalled.get(), (Matcher)CoreMatchers.is((Object)true));
            return true;
        }));
        new PollingProber(5000L, 100L).check((Probe)new JUnitLambdaProbe(() -> {
            MatcherAssert.assertThat((Object)getLoggerContextTimesCalled.get(), (Matcher)CoreMatchers.is((Object)2));
            return true;
        }));
        new PollingProber(5000L, 100L).check((Probe)new JUnitLambdaProbe(() -> {
            ((Logger)Mockito.verify((Object)regionClassLoaderLogger, (VerificationMode)Mockito.times((int)1))).info(log2);
            return true;
        }));
        nonBlockingLogThread.join();
        blockingLogThread.join();
    }

    private Logger getRegionClassLoader() throws ExecutionException {
        Logger containerLogger = (Logger)Mockito.mock(Logger.class);
        Logger regionClassLoaderLogger = (Logger)Mockito.mock(Logger.class);
        Mockito.when((Object)this.containerLoggerContext.getLogger(ArgumentMatchers.anyString(), (MessageFactory)ArgumentMatchers.any(MessageFactory.class))).thenReturn((Object)containerLogger);
        Mockito.when((Object)this.regionClassLoaderLoggerContext.getLogger(ArgumentMatchers.anyString(), (MessageFactory)ArgumentMatchers.any(MessageFactory.class))).thenReturn((Object)regionClassLoaderLogger);
        Mockito.when((Object)this.artifactAwareContextSelector.getContextWithResolvedContextClassLoader((ClassLoader)ArgumentMatchers.any())).thenAnswer(invocation -> this.loggerContextCache.getLoggerContext((ClassLoader)invocation.getArgument(0)));
        Mockito.when((Object)this.artifactAwareContextSelector.getLoggerContextCache()).thenReturn((Object)this.loggerContextCache);
        ((LoggerContextCache)Mockito.doAnswer(invocationOnMock -> this.containerLoggerContext).when((Object)this.loggerContextCache)).doGetLoggerContext((ClassLoader)ArgumentMatchers.eq((Object)this.currentClassLoader), (Integer)ArgumentMatchers.any());
        return regionClassLoaderLogger;
    }

    @Test
    public void currentClassLoader() {
        this.logger.info(MESSAGE);
        ((Logger)Mockito.verify((Object)this.originalLogger)).info(MESSAGE);
    }

    @Test
    public void anotherClassLoader() {
        ClassUtils.withContextClassLoader((ClassLoader)this.additionalClassLoader, () -> {
            this.logger.info(MESSAGE);
            ((Logger)Mockito.verify((Object)this.originalLogger)).info(MESSAGE);
        });
    }

    @Test
    public void regionClassLoader() {
        RegionClassLoader regionClassLoader = (RegionClassLoader)Mockito.mock(RegionClassLoader.class);
        ClassUtils.withContextClassLoader((ClassLoader)regionClassLoader, () -> {
            this.logger.info(MESSAGE);
            ((ContextSelector)Mockito.verify((Object)this.contextSelector)).getContext(LOGGER_NAME, (ClassLoader)regionClassLoader, true);
        });
    }

    @Test
    public void whenRecursiveLoggerContextInstantiationExceptionExpectFallbackUsingContainerClassLoader() {
        Logger containerLogger = (Logger)Mockito.mock(Logger.class);
        Logger regionClassLoaderLogger = (Logger)Mockito.mock(Logger.class);
        Mockito.when((Object)this.containerLoggerContext.getLogger(ArgumentMatchers.anyString(), (MessageFactory)ArgumentMatchers.any(MessageFactory.class))).thenReturn((Object)containerLogger);
        Mockito.when((Object)this.regionClassLoaderLoggerContext.getLogger(ArgumentMatchers.anyString(), (MessageFactory)ArgumentMatchers.any(MessageFactory.class))).thenReturn((Object)regionClassLoaderLogger);
        Mockito.when((Object)this.artifactAwareContextSelector.getContextWithResolvedContextClassLoader(this.currentClassLoader)).thenAnswer(invocation -> this.containerLoggerContext);
        Mockito.when((Object)this.artifactAwareContextSelector.getContextWithResolvedContextClassLoader((ClassLoader)this.regionClassLoader)).thenThrow(RecursiveLoggerContextInstantiationException.class).thenAnswer(invocation -> this.regionClassLoaderLoggerContext);
        DispatchingLogger dispatchingLogger = new DispatchingLogger(this.originalLogger, this.currentClassLoader.hashCode(), this.containerLoggerContext, (ContextSelector)this.artifactAwareContextSelector, this.messageFactory){

            public String getName() {
                return LOGGER_NAME;
            }
        };
        ClassUtils.withContextClassLoader((ClassLoader)this.regionClassLoader, () -> {
            dispatchingLogger.info("Fallback Test Message");
            dispatchingLogger.info("Test Message");
        });
        ((Logger)Mockito.verify((Object)containerLogger, (VerificationMode)Mockito.times((int)1))).info("Fallback Test Message");
        ((Logger)Mockito.verify((Object)regionClassLoaderLogger, (VerificationMode)Mockito.times((int)1))).info("Test Message");
    }

    @Test
    public void whenFallbackToContainerClassLoaderFailsReturnOriginalLogger() {
        Logger containerLogger = (Logger)Mockito.mock(Logger.class);
        Logger regionClassLoaderLogger = (Logger)Mockito.mock(Logger.class);
        Mockito.when((Object)this.containerLoggerContext.getLogger(ArgumentMatchers.anyString(), (MessageFactory)ArgumentMatchers.any(MessageFactory.class))).thenReturn((Object)containerLogger);
        Mockito.when((Object)this.regionClassLoaderLoggerContext.getLogger(ArgumentMatchers.anyString(), (MessageFactory)ArgumentMatchers.any(MessageFactory.class))).thenReturn((Object)regionClassLoaderLogger);
        Mockito.when((Object)this.artifactAwareContextSelector.getContextWithResolvedContextClassLoader(this.currentClassLoader)).thenThrow(RecursiveLoggerContextInstantiationException.class).thenAnswer(invocation -> this.containerLoggerContext);
        Mockito.when((Object)this.artifactAwareContextSelector.getContextWithResolvedContextClassLoader((ClassLoader)this.regionClassLoader)).thenThrow(RecursiveLoggerContextInstantiationException.class).thenAnswer(invocation -> this.regionClassLoaderLoggerContext);
        DispatchingLogger dispatchingLogger = new DispatchingLogger(this.originalLogger, this.currentClassLoader.hashCode(), this.containerLoggerContext, (ContextSelector)this.artifactAwareContextSelector, this.messageFactory){

            public String getName() {
                return LOGGER_NAME;
            }
        };
        ClassUtils.withContextClassLoader((ClassLoader)this.regionClassLoader, () -> {
            dispatchingLogger.info("Fallback Test Message");
            dispatchingLogger.info("Test Message");
        });
        ((Logger)Mockito.verify((Object)this.originalLogger, (VerificationMode)Mockito.times((int)1))).info("Fallback Test Message");
        ((Logger)Mockito.verify((Object)regionClassLoaderLogger, (VerificationMode)Mockito.times((int)1))).info("Test Message");
    }

    private class ClassOwningLoggerNeedingBlocking
    extends ClassOwningLogger {
        private ClassOwningLoggerNeedingBlocking() {
        }

        static {
            BlockingLoggerResolutionClassRegistry.getBlockingLoggerResolutionClassRegistry().registerClassNeedingBlockingLoggerResolution(ClassOwningLoggerNeedingBlocking.class);
        }
    }

    private class ClassOwningLogger {
        private final Logger logger = this.getLogger();

        private ClassOwningLogger() {
        }

        private Logger getLogger() {
            Logger logger = (Logger)Mockito.mock(Logger.class, (Answer)Answers.RETURNS_DEEP_STUBS);
            Mockito.when((Object)logger.getName()).thenReturn((Object)this.getClass().getName());
            return logger;
        }

        public DispatchingLogger getDispatchingLogger() {
            return (DispatchingLogger)Mockito.spy((Object)new DispatchingLogger(this.logger, DispatchingLoggerTestCase.this.currentClassLoader.hashCode(), DispatchingLoggerTestCase.this.containerLoggerContext, (ContextSelector)DispatchingLoggerTestCase.this.artifactAwareContextSelector, DispatchingLoggerTestCase.this.messageFactory){

                public String getName() {
                    return LOGGER_NAME;
                }
            });
        }
    }
}

