/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.logging.otel.impl.export.sniffer;

/**
 * Represents an Open Telemetry LogRecord captured by a {@link SniffedLogRecordExporter}
 *
 * @see io.opentelemetry.sdk.logs.data.LogRecordData
 */
public interface SniffedLogRecord {

  String getBody();

  String getSpanId();

  String getTraceId();

  String getSeverity();
}
