/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.logging.otel.impl.configuration;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.container.api.MuleFoldersUtil;
import org.mule.runtime.module.artifact.api.descriptor.DeployableArtifactDescriptor;
import org.mule.runtime.module.observability.AbstractFileObservabilitySignalConfiguration;
import org.mule.runtime.module.observability.configuration.ObservabilitySignalConfigurationFileFinder;
import org.mule.runtime.module.observability.configuration.ObservabilitySignalConfigurationPropertyResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileOpenTelemetryLoggingConfiguration
extends AbstractFileObservabilitySignalConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(FileOpenTelemetryLoggingConfiguration.class);
    private final DeployableArtifactDescriptor deployableArtifactDescriptor;

    public FileOpenTelemetryLoggingConfiguration(ObservabilitySignalConfigurationFileFinder artifactResourceFinder, ObservabilitySignalConfigurationPropertyResolver observabilitySignalConfigurationPropertyResolver, DeployableArtifactDescriptor deployableArtifactDescriptor) {
        super(artifactResourceFinder, observabilitySignalConfigurationPropertyResolver);
        this.deployableArtifactDescriptor = deployableArtifactDescriptor;
    }

    protected void onConfigurationFileNotFound() {
        logger.atInfo().log("Logging exporter configuration file named '{}' not found {}. Using default configuration.", (Object)this.getSignalConfigurationFileName(), (Object)this.getConfigurationFileLocations());
    }

    private String getConfigurationFileLocations() {
        if (FileOpenTelemetryLoggingConfiguration.isApplicationLevelConfigurable() && this.deployableArtifactDescriptor != null) {
            return String.format("at at both '%s' application resources and the '%s' configuration path", this.deployableArtifactDescriptor.getName(), this.getSignalConfigurationFileDirectoryPath());
        }
        return String.format("at the '%s' configuration path", this.getSignalConfigurationFileDirectoryPath());
    }

    protected void onConfigurationFileLoadError(Exception error, File configurationFile) {
        throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)String.format("Parsing error in the logging exporter configuration file '%s'.", configurationFile.getAbsolutePath()), (Object[])new Object[]{error}));
    }

    protected Path getSignalConfigurationFileDirectoryPath() {
        return Paths.get(System.getProperty("mule.openTelemetry.logging.exporter.configurationFilePath", MuleFoldersUtil.getConfFolder().getAbsolutePath()), new String[0]).toAbsolutePath();
    }

    protected String getSignalConfigurationFileName() {
        return System.getProperty("mule.openTelemetry.logging.exporter.configurationFileName", "logging-exporter.conf");
    }
}

