/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.utils.parameters;

import static java.lang.System.getProperty;
import static java.lang.System.setProperty;

import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

public class SystemProperty implements BeforeEachCallback, AfterEachCallback {

  private final String propertyName;
  private final String propertyValue;

  private String previousValue;

  public SystemProperty(String propertyName, String propertyValue) {
    this.propertyName = propertyName;
    this.propertyValue = propertyValue;
  }

  private void set() {
    previousValue = getProperty(propertyName);
    setProperty(propertyName, propertyValue);
  }

  private void unSet() {
    if (previousValue == null) {
      System.clearProperty(propertyName);
    } else {
      System.setProperty(propertyName, previousValue);
    }
  }

  public String getPropertyValue() {
    return propertyValue;
  }

  @Override
  public String toString() {
    return "propertyName='" + propertyName + '\'' + "propertyValue='" + propertyValue + '\'';
  }

  @Override
  public void afterEach(ExtensionContext context) {
    this.unSet();
  }

  @Override
  public void beforeEach(ExtensionContext context) {
    this.set();
  }
}
