/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.logging.otel.configuration.impl;

import static org.mule.runtime.logging.otel.impl.OpenTelemetryLoggingSDKFactory.getLogRecordSniffer;
import static org.mule.runtime.logging.otel.impl.OpenTelemetryLoggingSDKFactory.getOpenTelemetryLoggingSDK;
import static org.mule.runtime.utils.probe.PollingProber.probe;

import static org.hamcrest.CoreMatchers.equalTo;
import static org.hamcrest.MatcherAssert.assertThat;

import org.junit.jupiter.api.extension.RegisterExtension;
import org.mule.runtime.logging.otel.impl.export.sniffer.ExportedLogRecordSniffer;
import org.mule.runtime.logging.otel.impl.export.sniffer.SniffedLogRecord;
import org.mule.runtime.module.artifact.api.descriptor.DeployableArtifactDescriptor;
import org.mule.runtime.utils.parameters.SystemProperty;

import io.opentelemetry.api.OpenTelemetry;
import org.junit.jupiter.api.Test;

class OpenTelemetryLoggingSDKFactoryTestCase {

  private final DeployableArtifactDescriptor deployableArtifactDescriptor = new DeployableArtifactDescriptor("test-artifact");

  @RegisterExtension
  public SystemProperty useSniffedExporter = new SystemProperty("mule.openTelemetry.logging.exporter.use.sniffer", "true");

  @Test
  void testDefaultResourceAttributes() {
    OpenTelemetry loggingSDK = getOpenTelemetryLoggingSDK(deployableArtifactDescriptor, path -> null);
    ExportedLogRecordSniffer exportedLogRecordSniffer = getLogRecordSniffer();
    loggingSDK.getLogsBridge().loggerBuilder("otel").build().logRecordBuilder().setBody("Test").emit();
    probe(() -> exportedLogRecordSniffer.getSniffedLogRecords().size() == 1,
          () -> "Expected Log Record was not exported.");
    SniffedLogRecord sniffedLogRecord = exportedLogRecordSniffer.getSniffedLogRecords().get(0);
    assertThat(sniffedLogRecord.getBody(), equalTo("Test"));
  }

}
