/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.logging.otel.impl.configuration;

import org.mule.runtime.module.observability.configuration.ObservabilitySignalConfiguration;

import io.opentelemetry.sdk.logs.export.LogRecordExporter;

/**
 * An OpenTelemetry {@link LogRecordExporter} configurator.
 */
public interface LoggingExporterConfigurator {

  /**
   * Configures an OpenTelemetry {@link LogRecordExporter} according to the provided configuration.
   *
   * @param configuration The provided {@link ObservabilitySignalConfiguration}.
   * @return A configured {@link LogRecordExporter}
   * @throws LogRecordExporterConfiguratorException if the case of a configuration error.
   */
  LogRecordExporter configureExporter(ObservabilitySignalConfiguration configuration)
      throws LogRecordExporterConfiguratorException;

}
