/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.logging.otel.configuration.impl;

import static org.mule.runtime.logging.otel.api.configuration.OpenTelemetryLoggingConfigurationProperties.MULE_OPEN_TELEMETRY_LOGGING_EXPORTER_BACKOFF_MAX_ATTEMPTS;
import static org.mule.runtime.logging.otel.api.configuration.OpenTelemetryLoggingConfigurationProperties.MULE_OPEN_TELEMETRY_LOGGING_EXPORTER_BACKOFF_MULTIPLIER;
import static org.mule.runtime.logging.otel.api.configuration.OpenTelemetryLoggingConfigurationProperties.MULE_OPEN_TELEMETRY_LOGGING_EXPORTER_BATCH_BACKPRESSURE_STRATEGY;
import static org.mule.runtime.logging.otel.api.configuration.OpenTelemetryLoggingConfigurationProperties.MULE_OPEN_TELEMETRY_LOGGING_EXPORTER_BATCH_QUEUE_SIZE;
import static org.mule.runtime.logging.otel.api.configuration.OpenTelemetryLoggingConfigurationProperties.MULE_OPEN_TELEMETRY_LOGGING_EXPORTER_ENABLED;
import static org.mule.runtime.logging.otel.api.configuration.OpenTelemetryLoggingConfigurationProperties.MULE_OPEN_TELEMETRY_LOGGING_EXPORTER_ENDPOINT;
import static org.mule.runtime.logging.otel.api.configuration.OpenTelemetryLoggingConfigurationProperties.MULE_OPEN_TELEMETRY_LOGGING_EXPORTER_INITIAL_BACKOFF;
import static org.mule.runtime.logging.otel.api.configuration.OpenTelemetryLoggingConfigurationProperties.MULE_OPEN_TELEMETRY_LOGGING_EXPORTER_MAX_BACKOFF;
import static org.mule.runtime.logging.otel.api.configuration.OpenTelemetryLoggingConfigurationProperties.MULE_OPEN_TELEMETRY_LOGGING_EXPORTER_MAX_BATCH_SIZE;
import static org.mule.runtime.logging.otel.api.configuration.OpenTelemetryLoggingConfigurationProperties.MULE_OPEN_TELEMETRY_LOGGING_EXPORTER_SERVICE_NAMESPACE;
import static org.mule.runtime.logging.otel.api.configuration.OpenTelemetryLoggingConfigurationProperties.MULE_OPEN_TELEMETRY_LOGGING_EXPORTER_TIMEOUT;
import static org.mule.runtime.logging.otel.api.configuration.OpenTelemetryLoggingConfigurationProperties.MULE_OPEN_TELEMETRY_LOGGING_EXPORTER_TYPE;
import static org.mule.runtime.logging.otel.impl.configuration.OpenTelemetryAutoConfigurableLoggingConfiguration.DEFAULT_BACKOFF_MAX_ATTEMPTS;
import static org.mule.runtime.logging.otel.impl.configuration.OpenTelemetryAutoConfigurableLoggingConfiguration.DEFAULT_BACKOFF_MULTIPLIER;
import static org.mule.runtime.logging.otel.impl.configuration.OpenTelemetryAutoConfigurableLoggingConfiguration.DEFAULT_BATCH_BACKPRESSURE_STRATEGY;
import static org.mule.runtime.logging.otel.impl.configuration.OpenTelemetryAutoConfigurableLoggingConfiguration.DEFAULT_BATCH_MAX_BATCH_SIZE;
import static org.mule.runtime.logging.otel.impl.configuration.OpenTelemetryAutoConfigurableLoggingConfiguration.DEFAULT_BATCH_QUEUE_SIZE;
import static org.mule.runtime.logging.otel.impl.configuration.OpenTelemetryAutoConfigurableLoggingConfiguration.DEFAULT_EXPORTER_TIMEOUT;
import static org.mule.runtime.logging.otel.impl.configuration.OpenTelemetryAutoConfigurableLoggingConfiguration.DEFAULT_HTTP_EXPORTER_ENDPOINT;
import static org.mule.runtime.logging.otel.impl.configuration.OpenTelemetryAutoConfigurableLoggingConfiguration.DEFAULT_INITIAL_BACKOFF;
import static org.mule.runtime.logging.otel.impl.configuration.OpenTelemetryAutoConfigurableLoggingConfiguration.DEFAULT_MAXIMUM_BACKOFF;
import static org.mule.runtime.logging.otel.impl.configuration.OpenTelemetryAutoConfigurableLoggingConfiguration.DEFAULT_SERVICE_NAMESPACE;
import static org.mule.runtime.logging.otel.impl.configuration.OpenTelemetryAutoConfigurableLoggingConfiguration.HTTP_EXPORTER_TYPE;

import static org.hamcrest.CoreMatchers.equalTo;
import static org.hamcrest.MatcherAssert.assertThat;

import org.mule.runtime.logging.otel.impl.configuration.OpenTelemetryAutoConfigurableLoggingConfiguration;
import org.mule.runtime.module.observability.configuration.ObservabilitySignalConfiguration;

import org.junit.jupiter.api.Test;

class OpenTelemetryAutoConfigurableLoggingConfigurationTestCase {

  @Test
  void testDefaultConfiguration() {
    OpenTelemetryAutoConfigurableLoggingConfiguration openTelemetryAutoConfigurableLoggingConfiguration =
        new OpenTelemetryAutoConfigurableLoggingConfiguration(new NoConfigurationDelegate());
    assertThat(openTelemetryAutoConfigurableLoggingConfiguration.getStringValue(MULE_OPEN_TELEMETRY_LOGGING_EXPORTER_ENABLED),
               equalTo("false"));
    assertThat(openTelemetryAutoConfigurableLoggingConfiguration.getStringValue(MULE_OPEN_TELEMETRY_LOGGING_EXPORTER_TYPE),
               equalTo(HTTP_EXPORTER_TYPE));
    assertThat(openTelemetryAutoConfigurableLoggingConfiguration.getStringValue(MULE_OPEN_TELEMETRY_LOGGING_EXPORTER_ENDPOINT),
               equalTo(DEFAULT_HTTP_EXPORTER_ENDPOINT));
    assertThat(openTelemetryAutoConfigurableLoggingConfiguration.getStringValue(MULE_OPEN_TELEMETRY_LOGGING_EXPORTER_TIMEOUT),
               equalTo(DEFAULT_EXPORTER_TIMEOUT));
    assertThat(openTelemetryAutoConfigurableLoggingConfiguration
        .getStringValue(MULE_OPEN_TELEMETRY_LOGGING_EXPORTER_BACKOFF_MULTIPLIER), equalTo(DEFAULT_BACKOFF_MULTIPLIER));
    assertThat(openTelemetryAutoConfigurableLoggingConfiguration
        .getStringValue(MULE_OPEN_TELEMETRY_LOGGING_EXPORTER_INITIAL_BACKOFF), equalTo(DEFAULT_INITIAL_BACKOFF));
    assertThat(openTelemetryAutoConfigurableLoggingConfiguration.getStringValue(MULE_OPEN_TELEMETRY_LOGGING_EXPORTER_MAX_BACKOFF),
               equalTo(DEFAULT_MAXIMUM_BACKOFF));
    assertThat(openTelemetryAutoConfigurableLoggingConfiguration
        .getStringValue(MULE_OPEN_TELEMETRY_LOGGING_EXPORTER_BACKOFF_MAX_ATTEMPTS), equalTo(DEFAULT_BACKOFF_MAX_ATTEMPTS));
    assertThat(openTelemetryAutoConfigurableLoggingConfiguration
        .getStringValue(MULE_OPEN_TELEMETRY_LOGGING_EXPORTER_BATCH_QUEUE_SIZE), equalTo(DEFAULT_BATCH_QUEUE_SIZE));
    assertThat(openTelemetryAutoConfigurableLoggingConfiguration
        .getStringValue(MULE_OPEN_TELEMETRY_LOGGING_EXPORTER_MAX_BATCH_SIZE), equalTo(DEFAULT_BATCH_MAX_BATCH_SIZE));
    assertThat(openTelemetryAutoConfigurableLoggingConfiguration
        .getStringValue(MULE_OPEN_TELEMETRY_LOGGING_EXPORTER_BATCH_BACKPRESSURE_STRATEGY),
               equalTo(DEFAULT_BATCH_BACKPRESSURE_STRATEGY));
    assertThat(openTelemetryAutoConfigurableLoggingConfiguration
        .getStringValue(MULE_OPEN_TELEMETRY_LOGGING_EXPORTER_SERVICE_NAMESPACE),
               equalTo(DEFAULT_SERVICE_NAMESPACE));
  }

  private static class NoConfigurationDelegate implements ObservabilitySignalConfiguration {

    @Override
    public String getStringValue(String key) {
      return null;
    }

    @Override
    public String getStringValue(String key, String defaultValue) {
      return defaultValue;
    }

    @Override
    public void doOnConfigurationChanged(Runnable doOnConfigurationChanged) {
      // Nothing to do.
    }
  }

}
