/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.logging.otel.impl.configuration;

import org.mule.runtime.api.exception.MuleRuntimeException;

import static org.mule.runtime.api.i18n.I18nMessageFactory.createStaticMessage;

/**
 * Exception that represents an error during the configuration of a log record exporter.
 *
 * @see LoggingExporterConfigurator
 */
public class LogRecordExporterConfiguratorException extends MuleRuntimeException {

  public LogRecordExporterConfiguratorException(Exception cause) {
    super(cause);
  }

  public LogRecordExporterConfiguratorException(String s) {
    super(createStaticMessage(s));
  }
}
