/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.internal.memory.bytebuffer;

import java.nio.ByteBuffer;
import java.util.Arrays;
import org.mule.runtime.api.memory.provider.ByteBufferProvider;
import org.mule.runtime.api.profiling.ProfilingDataProducer;
import org.mule.runtime.api.profiling.ProfilingEventContext;
import org.mule.runtime.api.profiling.ProfilingProducerScope;
import org.mule.runtime.api.profiling.ProfilingService;
import org.mule.runtime.api.profiling.type.RuntimeProfilingEventTypes;
import org.mule.runtime.api.profiling.type.context.ByteBufferProviderEventContext;
import org.mule.runtime.internal.memory.bytebuffer.ByteBufferPool;
import org.mule.runtime.internal.memory.bytebuffer.profiling.ContainerProfilingScope;
import org.mule.runtime.internal.memory.bytebuffer.profiling.DefaultByteBufferProviderEventContext;

public abstract class ThreadPoolBasedByteBufferProvider
implements ByteBufferProvider<ByteBuffer> {
    public static final int DEFAULT_MAX_BUFFER_SIZE = 65536;
    private static final int DEFAULT_BASE_BYTE_BUFFER_SIZE = 1;
    private static final int DEFAULT_GROWTH_FACTOR = 1;
    private static final int DEFAULT_NUMBER_OF_FIX_SIZED_POOLS = 0;
    protected final int maxBufferSize;
    private final ByteBufferPool<ByteBuffer>[] pools;
    private final String name;
    ProfilingDataProducer<ByteBufferProviderEventContext, Object> allocationDataProducer;
    ProfilingDataProducer<ByteBufferProviderEventContext, Object> deallocationDataProducer;

    protected ThreadPoolBasedByteBufferProvider(String name, ProfilingService profilingService) {
        this(name, 65536, 1, 1, 0, profilingService);
    }

    protected ThreadPoolBasedByteBufferProvider(String name, int maxBufferSize, int baseByteBufferSize, int growthFactor, int numberOfPools, ProfilingService profilingService) {
        this.name = name;
        if (maxBufferSize <= 0) {
            throw new IllegalArgumentException("maxBufferSize must be greater than zero");
        }
        if (baseByteBufferSize <= 0) {
            throw new IllegalArgumentException("baseByteBufferSize must be greater than zero");
        }
        if (numberOfPools < 0) {
            throw new IllegalArgumentException("numberOfPools must be greater than zero");
        }
        if (!this.isPowerOfTwo(baseByteBufferSize) || !this.isPowerOfTwo(growthFactor)) {
            throw new IllegalArgumentException("baseByteBufferSize and growthFactor must be a power of two");
        }
        this.maxBufferSize = maxBufferSize;
        this.pools = new ByteBufferPool[numberOfPools + 1];
        int i = 0;
        int bufferSize = baseByteBufferSize;
        while (i < numberOfPools) {
            this.pools[i] = new ThreadLocalByteBufferWrapper(bufferSize);
            ++i;
            bufferSize <<= growthFactor;
        }
        this.allocationDataProducer = profilingService.getProfilingDataProducer(RuntimeProfilingEventTypes.MEMORY_BYTE_BUFFER_ALLOCATION, (ProfilingProducerScope)new ContainerProfilingScope());
        this.deallocationDataProducer = profilingService.getProfilingDataProducer(RuntimeProfilingEventTypes.MEMORY_BYTE_BUFFER_DEALLOCATION, (ProfilingProducerScope)new ContainerProfilingScope());
        this.pools[numberOfPools] = new ThreadLocalByteBufferWrapper(maxBufferSize);
    }

    private boolean isPowerOfTwo(int valueToCheck) {
        return (valueToCheck & valueToCheck - 1) == 0;
    }

    protected abstract ByteBuffer doAllocate(int var1);

    public ByteBuffer allocate(int size) {
        this.allocationDataProducer.triggerProfilingEvent((ProfilingEventContext)new DefaultByteBufferProviderEventContext(this.name, System.currentTimeMillis(), size));
        return this.allocateByteBuffer(size);
    }

    private ByteBuffer allocateByteBuffer(int size) {
        if (size > this.maxBufferSize) {
            return this.doAllocate(size);
        }
        ByteBufferPool<ByteBuffer> threadLocalCache = this.getByteBufferThreadLocalPool(size);
        if (threadLocalCache != null) {
            int remaining = threadLocalCache.remaining();
            if (remaining == 0 || remaining < size) {
                ByteBuffer byteBuffer = this.doAllocate(threadLocalCache.getMaxBufferSize());
                threadLocalCache.reset(byteBuffer);
            }
            return (ByteBuffer)this.allocateFromPool(threadLocalCache, size);
        }
        return this.doAllocate(size);
    }

    private Object allocateFromPool(ByteBufferPool<ByteBuffer> threadLocalCache, int size) {
        if (threadLocalCache.remaining() >= size) {
            return threadLocalCache.allocate(size);
        }
        return null;
    }

    private void reallocatePoolBuffer(int size) {
        ByteBuffer byteBuffer = this.doAllocate(size);
        ByteBufferPool<ByteBuffer> threadLocalCache = this.getByteBufferThreadLocalPool(size);
        if (threadLocalCache != null) {
            threadLocalCache.reset(byteBuffer);
        }
    }

    private ByteBufferPool<ByteBuffer> getByteBufferThreadLocalPool(int size) {
        for (ByteBufferPool<ByteBuffer> pool : this.pools) {
            if (pool.getMaxBufferSize() < size) continue;
            return pool;
        }
        return null;
    }

    public ByteBuffer allocateAtLeast(int size) {
        return this.allocateByteBufferAtLeast(size);
    }

    private ByteBuffer allocateByteBufferAtLeast(int size) {
        if (size > this.maxBufferSize) {
            return this.doAllocate(size);
        }
        ByteBufferPool<ByteBuffer> threadLocalCache = this.getByteBufferThreadLocalPool(size);
        if (threadLocalCache != null) {
            int remaining = threadLocalCache.remaining();
            if (remaining == 0 || remaining < size) {
                this.reallocatePoolBuffer(size);
                remaining = threadLocalCache.remaining();
            }
            return (ByteBuffer)this.allocateFromPool(threadLocalCache, remaining);
        }
        return this.doAllocate(size);
    }

    public ByteBuffer reallocate(ByteBuffer oldBuffer, int newSize) {
        return this.reallocateByteBuffer(oldBuffer, newSize);
    }

    private ByteBuffer reallocateByteBuffer(ByteBuffer oldByteBuffer, int newSize) {
        ByteBuffer newBuffer;
        if (oldByteBuffer.capacity() >= newSize) {
            return oldByteBuffer;
        }
        ByteBufferPool<ByteBuffer> memoryPool = this.getByteBufferThreadLocalPool(newSize);
        if (memoryPool != null && (newBuffer = memoryPool.reallocate(oldByteBuffer, newSize)) != null) {
            return newBuffer;
        }
        ByteBuffer newByteBuffer = this.allocateByteBuffer(newSize);
        if (newByteBuffer == null) {
            throw new IllegalStateException(String.format("It was not possible to allocate reallocate a buffer with size '%s'", newSize));
        }
        oldByteBuffer.flip();
        return newByteBuffer.put(oldByteBuffer);
    }

    public void release(ByteBuffer byteBuffer) {
        this.deallocationDataProducer.triggerProfilingEvent((ProfilingEventContext)new DefaultByteBufferProviderEventContext(this.name, System.currentTimeMillis(), byteBuffer.limit()));
        ByteBufferPool<ByteBuffer> memoryPool = this.getByteBufferThreadLocalPool(byteBuffer.limit());
        if (memoryPool != null) {
            memoryPool.release((ByteBuffer)byteBuffer.clear());
        }
    }

    public byte[] getByteArray(int size) {
        return new byte[size];
    }

    public void dispose() {
        for (ByteBufferPool<ByteBuffer> pool : this.pools) {
            pool.dispose();
        }
    }

    protected ByteBufferPool<ByteBuffer>[] getThreadLocalPools() {
        return this.pools;
    }

    private static final class ByteBufferThreadLocalPool
    implements ByteBufferPool<ByteBuffer> {
        private ByteBuffer pool;
        private Object[] allocationHistory = new Object[8];
        private int lastAllocatedIndex;
        private final int maxBufferSize;

        public ByteBufferThreadLocalPool(int maxBufferSize) {
            this.maxBufferSize = maxBufferSize;
        }

        @Override
        public void reset(ByteBuffer pool) {
            Arrays.fill(this.allocationHistory, 0, this.lastAllocatedIndex, null);
            this.lastAllocatedIndex = 0;
            this.pool = pool;
        }

        @Override
        public ByteBuffer allocate(int size) {
            ByteBuffer allocated = this.slice(this.pool, size);
            return this.addHistory(allocated);
        }

        @Override
        public ByteBuffer reallocate(ByteBuffer oldByteBuffer, int newSize) {
            if (this.isLastAllocated(oldByteBuffer) && this.remaining() + oldByteBuffer.capacity() >= newSize) {
                --this.lastAllocatedIndex;
                this.pool.position(this.pool.position() - oldByteBuffer.capacity());
                ByteBuffer newByteBuffer = this.slice(this.pool, newSize);
                newByteBuffer.position(oldByteBuffer.position());
                return this.addHistory(newByteBuffer);
            }
            return null;
        }

        private ByteBuffer slice(ByteBuffer chunk, int size) {
            chunk.limit(chunk.position() + size);
            ByteBuffer view = chunk.slice();
            chunk.position(chunk.limit());
            chunk.limit(chunk.capacity());
            return view;
        }

        @Override
        public boolean release(ByteBuffer byteBuffer) {
            if (this.isLastAllocated(byteBuffer)) {
                this.pool.position(this.pool.position() - byteBuffer.capacity());
                this.allocationHistory[--this.lastAllocatedIndex] = null;
                return true;
            }
            if (this.wantReset(byteBuffer.capacity())) {
                this.reset(byteBuffer);
                return true;
            }
            return false;
        }

        public boolean wantReset(int size) {
            return !this.hasRemaining() || this.lastAllocatedIndex == 0 && this.pool.remaining() < size;
        }

        public boolean isLastAllocated(ByteBuffer oldByteBuffer) {
            return this.lastAllocatedIndex > 0 && this.allocationHistory[this.lastAllocatedIndex - 1] == oldByteBuffer;
        }

        @Override
        public ByteBuffer reduceLastAllocated(ByteBuffer byteBuffer) {
            ByteBuffer oldLastAllocated = (ByteBuffer)this.allocationHistory[this.lastAllocatedIndex - 1];
            this.pool.position(this.pool.position() - (oldLastAllocated.capacity() - byteBuffer.capacity()));
            this.allocationHistory[this.lastAllocatedIndex - 1] = byteBuffer;
            return oldLastAllocated;
        }

        @Override
        public int remaining() {
            return this.pool != null ? this.pool.remaining() : 0;
        }

        @Override
        public boolean hasRemaining() {
            return this.remaining() > 0;
        }

        @Override
        public int getMaxBufferSize() {
            return this.maxBufferSize;
        }

        @Override
        public void dispose() {
        }

        private ByteBuffer addHistory(ByteBuffer allocated) {
            if (this.lastAllocatedIndex >= this.allocationHistory.length) {
                this.allocationHistory = Arrays.copyOf(this.allocationHistory, this.allocationHistory.length * 3 / 2 + 1);
            }
            this.allocationHistory[this.lastAllocatedIndex++] = allocated;
            return allocated;
        }

        public String toString() {
            return "(pool=" + this.pool + " last-allocated-index=" + (this.lastAllocatedIndex - 1) + " allocation-history=" + Arrays.toString(this.allocationHistory) + ')';
        }
    }

    private static final class ThreadLocalByteBufferWrapper
    implements ByteBufferPool<ByteBuffer> {
        private final int bufferSize;
        private final ThreadLocal<ByteBufferPool<ByteBuffer>> delegate = new ThreadLocal();

        public ThreadLocalByteBufferWrapper(int bufferSize) {
            this.bufferSize = bufferSize;
        }

        @Override
        public ByteBuffer reallocate(ByteBuffer oldByteBuffer, int newSize) {
            return this.getDelegate().reallocate(oldByteBuffer, newSize);
        }

        @Override
        public boolean release(ByteBuffer byteBuffer) {
            return this.getDelegate().release(byteBuffer);
        }

        @Override
        public ByteBuffer reduceLastAllocated(ByteBuffer byteBuffer) {
            return this.getDelegate().reduceLastAllocated(byteBuffer);
        }

        @Override
        public int remaining() {
            return this.getDelegate().remaining();
        }

        @Override
        public void reset(ByteBuffer byteBuffer) {
            this.getDelegate().reset(byteBuffer);
        }

        @Override
        public ByteBuffer allocate(int size) {
            return this.getDelegate().allocate(size);
        }

        @Override
        public boolean hasRemaining() {
            return this.getDelegate().hasRemaining();
        }

        @Override
        public int getMaxBufferSize() {
            return this.getDelegate().getMaxBufferSize();
        }

        @Override
        public void dispose() {
            this.delegate.remove();
        }

        private ByteBufferPool<ByteBuffer> getDelegate() {
            if (this.delegate.get() == null) {
                this.delegate.set(new ByteBufferThreadLocalPool(this.bufferSize));
            }
            return this.delegate.get();
        }
    }
}

