/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.internal.memory.bytebuffer;

import java.nio.ByteBuffer;
import org.mule.runtime.api.memory.provider.ByteBufferPoolConfiguration;
import org.mule.runtime.api.memory.provider.ByteBufferProvider;
import org.mule.runtime.api.memory.provider.type.ByteBufferPoolStrategy;
import org.mule.runtime.api.memory.provider.type.ByteBufferType;
import org.mule.runtime.api.profiling.ProfilingService;
import org.mule.runtime.internal.memory.bytebuffer.DirectByteBufferProvider;
import org.mule.runtime.internal.memory.bytebuffer.HeapByteBufferProvider;
import org.mule.runtime.internal.memory.bytebuffer.WeavePoolBasedByteBufferProvider;
import org.mule.runtime.internal.memory.profiling.NoOpMemoryProfilingService;

public final class ByteBufferProviderBuilder {
    public static final String BYTE_BUFFER_PROVIDER_NAME_CANNOT_BE_NULL_MESSAGE = "Byte buffer provider name cannot be null.";
    public static final String PROFILING_SERVICE_CANNOT_BE_NULL_MESSAGE = "Profiling service cannot be null.";
    private final boolean isDirect;
    private ByteBufferPoolConfiguration poolConfiguration;
    private ProfilingService profilingService = NoOpMemoryProfilingService.getNoOpMemoryProfilingService();
    private String name;

    private ByteBufferProviderBuilder(boolean isDirect) {
        this.isDirect = isDirect;
    }

    public static ByteBufferProviderBuilder buildByteBufferProviderFrom(ByteBufferType byteBufferType) {
        return new ByteBufferProviderBuilder(ByteBufferType.DIRECT.equals((Object)byteBufferType));
    }

    public ByteBufferProvider<ByteBuffer> build() {
        if (this.profilingService == null) {
            throw new IllegalArgumentException(PROFILING_SERVICE_CANNOT_BE_NULL_MESSAGE);
        }
        if (this.name == null) {
            throw new IllegalArgumentException(BYTE_BUFFER_PROVIDER_NAME_CANNOT_BE_NULL_MESSAGE);
        }
        if (this.isDirect) {
            if (this.poolConfiguration != null) {
                if (this.poolConfiguration.getByteBufferPoolStrategy() == ByteBufferPoolStrategy.FIXED_BUFFERS_POOL) {
                    return new WeavePoolBasedByteBufferProvider(this.name, this.poolConfiguration.getMaxBufferSize(), this.poolConfiguration.getNumberOfPools(), this.profilingService);
                }
                return new DirectByteBufferProvider(this.name, this.poolConfiguration.getMaxBufferSize(), this.poolConfiguration.getBaseByteBufferSize(), this.poolConfiguration.getGrowthFactor(), this.poolConfiguration.getNumberOfPools(), this.profilingService);
            }
            return new DirectByteBufferProvider(this.name, this.profilingService);
        }
        if (this.poolConfiguration != null) {
            return new HeapByteBufferProvider(this.name, this.poolConfiguration.getMaxBufferSize(), this.poolConfiguration.getBaseByteBufferSize(), this.poolConfiguration.getGrowthFactor(), this.poolConfiguration.getNumberOfPools(), this.profilingService);
        }
        return new HeapByteBufferProvider(this.name, this.profilingService);
    }

    public ByteBufferProviderBuilder withPoolConfiguration(ByteBufferPoolConfiguration poolConfiguration) {
        this.poolConfiguration = poolConfiguration;
        return this;
    }

    public ByteBufferProviderBuilder withProfilingService(ProfilingService profilingService) {
        this.profilingService = profilingService;
        return this;
    }

    public ByteBufferProviderBuilder withName(String name) {
        this.name = name;
        return this;
    }
}

