/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.internal.memory.management;

import java.nio.ByteBuffer;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.memory.provider.ByteBufferPoolConfiguration;
import org.mule.runtime.api.memory.provider.ByteBufferProvider;
import org.mule.runtime.api.memory.provider.type.ByteBufferType;
import org.mule.runtime.api.profiling.ProfilingService;
import org.mule.runtime.internal.memory.bytebuffer.ByteBufferProviderBuilder;
import org.mule.runtime.internal.memory.management.ProfiledMemoryManagementService;
import org.mule.runtime.internal.memory.profiling.NoOpMemoryProfilingService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultMemoryManagementService
implements ProfiledMemoryManagementService {
    public static final String DUPLICATE_BYTE_BUFFER_PROVIDER_NAME = "A ByteBuffer Provider is already registered with name '%s'.";
    private static final DefaultMemoryManagementService INSTANCE = new DefaultMemoryManagementService();
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultMemoryManagementService.class);
    private final Map<String, ByteBufferProvider<ByteBuffer>> byteBufferProviders = new ConcurrentHashMap<String, ByteBufferProvider<ByteBuffer>>();
    private ProfilingService profilingService = NoOpMemoryProfilingService.getNoOpMemoryProfilingService();

    public static DefaultMemoryManagementService getInstance() {
        return INSTANCE;
    }

    public static DefaultMemoryManagementService newDefaultMemoryManagementService() {
        return new DefaultMemoryManagementService();
    }

    private DefaultMemoryManagementService() {
    }

    public void dispose() {
        this.byteBufferProviders.values().forEach(ByteBufferProvider::dispose);
        this.byteBufferProviders.clear();
    }

    public void initialise() throws InitialisationException {
    }

    public synchronized ByteBufferProvider<ByteBuffer> getByteBufferProvider(String name, ByteBufferType byteBufferType, ByteBufferPoolConfiguration poolConfiguration) {
        if (name == null) {
            throw new IllegalArgumentException("Byte buffer provider name cannot be null.");
        }
        if (this.byteBufferProviders.containsKey(name)) {
            throw new IllegalArgumentException(String.format(DUPLICATE_BYTE_BUFFER_PROVIDER_NAME, name));
        }
        this.byteBufferProviders.put(name, ByteBufferProviderBuilder.buildByteBufferProviderFrom(byteBufferType).withPoolConfiguration(poolConfiguration).withProfilingService(this.profilingService).withName(name).build());
        return this.byteBufferProviders.get(name);
    }

    public synchronized ByteBufferProvider<ByteBuffer> getByteBufferProvider(String name, ByteBufferType byteBufferType) {
        if (name == null) {
            throw new IllegalArgumentException("Byte buffer provider name cannot be null.");
        }
        if (this.byteBufferProviders.containsKey(name)) {
            throw new IllegalArgumentException(String.format(DUPLICATE_BYTE_BUFFER_PROVIDER_NAME, name));
        }
        this.byteBufferProviders.put(name, ByteBufferProviderBuilder.buildByteBufferProviderFrom(byteBufferType).withName(name).withProfilingService(this.profilingService).build());
        return this.byteBufferProviders.get(name);
    }

    public synchronized void disposeByteBufferProvider(String name) {
        ByteBufferProvider<ByteBuffer> bufferProvider = this.byteBufferProviders.remove(name);
        if (bufferProvider != null) {
            bufferProvider.dispose();
        } else {
            LOGGER.warn("Unable to dispose not present ByteBufferProvider '{}'", (Object)name);
        }
    }

    @Override
    public void setProfilingService(ProfilingService profilingService) {
        this.profilingService = profilingService;
    }
}

