/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.metadata.internal.cache;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.Serializable;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.lock.LockFactory;
import org.mule.runtime.api.metadata.MetadataCache;
import org.mule.runtime.api.store.ObjectDoesNotExistException;
import org.mule.runtime.api.store.ObjectStore;
import org.mule.runtime.api.store.ObjectStoreException;
import org.mule.runtime.api.store.ObjectStoreManager;
import org.mule.runtime.api.store.ObjectStoreSettings;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.metadata.internal.cache.DefaultMetadataCache;
import org.mule.runtime.metadata.internal.cache.MetadataCacheManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPersistentMetadataCacheManager
implements MetadataCacheManager,
Startable {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultPersistentMetadataCacheManager.class);
    public static final String PERSISTENT_METADATA_SERVICE_CACHE = "_mulePersistentMetadataService";
    public static final String MULE_METADATA_CACHE_ENTRY_TTL = "mule.metadata.cache.entryTtl.minutes";
    public static final String MULE_METADATA_CACHE_EXPIRATION_INTERVAL = "mule.metadata.cache.expirationInterval.millis";
    @Inject
    @Named(value="_muleObjectStoreManager")
    private ObjectStoreManager objectStoreManager;
    @Inject
    private LockFactory lockFactory;
    private LazyValue<ObjectStore<MetadataCache>> metadataStore;

    public void setLockFactory(LockFactory lockFactory) {
        this.lockFactory = lockFactory;
    }

    public void setObjectStoreManager(ObjectStoreManager objectStoreManager) {
        this.objectStoreManager = objectStoreManager;
    }

    public void start() {
        this.metadataStore = new LazyValue(() -> {
            ObjectStoreSettings.Builder builder = ObjectStoreSettings.builder().persistent(true);
            this.getSystemProperty(MULE_METADATA_CACHE_ENTRY_TTL).map(stringValue -> NumberUtils.toLong((String)stringValue)).ifPresent(entryTtl -> builder.entryTtl(Long.valueOf(TimeUnit.MINUTES.convert((long)entryTtl, TimeUnit.MILLISECONDS))));
            this.getSystemProperty(MULE_METADATA_CACHE_EXPIRATION_INTERVAL).map(stringValue -> NumberUtils.toLong((String)stringValue)).ifPresent(expirationInterval -> builder.expirationInterval(expirationInterval));
            return this.objectStoreManager.getOrCreateObjectStore(PERSISTENT_METADATA_SERVICE_CACHE, builder.build());
        });
    }

    private Optional<String> getSystemProperty(String propertyName) {
        return Optional.ofNullable(System.getProperty(propertyName, null));
    }

    @Override
    public MetadataCache getOrCreateCache(String id) {
        return this.withKeyLock(id, key -> {
            try {
                if (((ObjectStore)this.metadataStore.get()).contains(key)) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug(String.format("Retrieving cache from OS with ID '%s'", id));
                    }
                    return (MetadataCache)((ObjectStore)this.metadataStore.get()).retrieve(key);
                }
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug(String.format("Creating new cache in OS with ID '%s'", id));
                }
                DefaultMetadataCache metadataCache = new DefaultMetadataCache();
                ((ObjectStore)this.metadataStore.get()).store(key, (Serializable)((Object)metadataCache));
                return metadataCache;
            }
            catch (Exception e) {
                String msg = String.format("An error occurred while retrieving the MetadataCache with ID '%s': %s", id, e.getMessage());
                LOGGER.error(msg);
                throw new RuntimeException(msg, e);
            }
        });
    }

    @Override
    public void updateCache(String id, MetadataCache cache) {
        this.withKeyLock(id, key -> {
            try {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug(String.format("Updating cache in OS with ID '%s'", id));
                }
                if (((ObjectStore)this.metadataStore.get()).contains(key)) {
                    ((ObjectStore)this.metadataStore.get()).remove(key);
                }
                ((ObjectStore)this.metadataStore.get()).store(key, (Serializable)cache);
            }
            catch (Exception e) {
                String msg = String.format("An error occurred while updating the MetadataCache with ID '%s': %s", id, e.getMessage());
                LOGGER.error(msg);
                throw new RuntimeException(msg, e);
            }
            return null;
        });
    }

    @Override
    public void dispose(String keyHash) {
        this.withKeyLock(keyHash, key -> {
            try {
                if (StringUtils.isBlank((CharSequence)keyHash)) {
                    this.clearMetadataCaches();
                } else {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug(String.format("Removing cache in OS with ID '%s'", key));
                    }
                    ((ObjectStore)this.metadataStore.get()).remove(key);
                }
            }
            catch (ObjectDoesNotExistException e) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug(String.format("No exact match found for key '%s'. Disposing all the elements with a prefix matching the given value.", key));
                }
                this.disposeAllMatches(keyHash);
            }
            catch (Exception e) {
                String msg = String.format("An error occurred while disposing the MetadataCache with ID '%s': %s", keyHash, e.getMessage());
                LOGGER.error(msg);
                throw new RuntimeException(msg, e);
            }
            return null;
        });
    }

    private void disposeAllMatches(String keyHash) {
        try {
            ((ObjectStore)this.metadataStore.get()).allKeys().stream().filter(id -> id.startsWith(keyHash)).forEach(id -> {
                block2: {
                    try {
                        this.dispose((String)id);
                    }
                    catch (Exception inner) {
                        if (!LOGGER.isDebugEnabled()) break block2;
                        LOGGER.debug(String.format("Failed to dispose ID '%s' with partial prefix match: %s", id, inner.getMessage()));
                    }
                }
            });
        }
        catch (ObjectStoreException e) {
            String msg = String.format("Failed to perform a cache disposal for partial prefix ID '%s': %s", keyHash, e.getMessage());
            LOGGER.error(msg);
            throw new RuntimeException(msg, e);
        }
    }

    private void clearMetadataCaches() {
        try {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Clearing cache from OS");
            }
            ((ObjectStore)this.metadataStore.get()).clear();
        }
        catch (ObjectStoreException e) {
            String msg = String.format("An error occurred while clearing MetadataCaches: %s", e.getMessage());
            LOGGER.error(msg);
            throw new RuntimeException(msg, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T withKeyLock(String key, Function<String, T> producer) {
        Lock lock = this.lockFactory.createLock(key);
        lock.lock();
        try {
            T t = producer.apply(key);
            return t;
        }
        finally {
            lock.unlock();
        }
    }
}

