/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.metadata.internal.cache;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.io.Serializable;
import java.util.Arrays;
import java.util.concurrent.locks.Lock;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnit;
import org.mockito.junit.MockitoRule;
import org.mockito.quality.Strictness;
import org.mockito.verification.VerificationMode;
import org.mule.runtime.api.lock.LockFactory;
import org.mule.runtime.api.metadata.MetadataCache;
import org.mule.runtime.api.store.ObjectDoesNotExistException;
import org.mule.runtime.api.store.ObjectStore;
import org.mule.runtime.api.store.ObjectStoreException;
import org.mule.runtime.api.store.ObjectStoreManager;
import org.mule.runtime.api.store.ObjectStoreSettings;
import org.mule.runtime.metadata.internal.cache.DefaultMetadataCache;
import org.mule.runtime.metadata.internal.cache.DefaultPersistentMetadataCacheManager;
import org.mule.tck.junit4.AbstractMuleTestCase;

@Feature(value="SDK Tooling Support")
@Story(value="Metadata Service")
public class DefaultMetadataCacheManagerTestCase
extends AbstractMuleTestCase {
    @Rule
    public MockitoRule rule = MockitoJUnit.rule().strictness(Strictness.STRICT_STUBS);
    private static final String SOME_KEY = "1874947571-1840879217-380895431-1745289126";
    private static final String OTHER_KEY = "1874947571-1840879217-123123123-1745289126";
    @Mock
    private ObjectStoreManager objectStoreManager;
    @Mock
    private LockFactory lockFactory;
    @Mock
    private Lock mockLock;
    @Mock
    private ObjectStore<MetadataCache> objectStore;
    @Mock
    private MetadataCache mockCache;
    @InjectMocks
    private final DefaultPersistentMetadataCacheManager cacheManager = new DefaultPersistentMetadataCacheManager();

    @Before
    public void setUp() {
        Mockito.when((Object)this.lockFactory.createLock(ArgumentMatchers.anyString())).thenReturn((Object)this.mockLock);
        Mockito.when((Object)this.objectStoreManager.getOrCreateObjectStore(ArgumentMatchers.anyString(), (ObjectStoreSettings)ArgumentMatchers.any())).thenReturn(this.objectStore);
        this.cacheManager.start();
    }

    @Test
    public void createCacheWhenMissingKey() throws ObjectStoreException {
        Mockito.when((Object)this.objectStore.contains(SOME_KEY)).thenReturn((Object)false);
        MetadataCache cache = this.cacheManager.getOrCreateCache(SOME_KEY);
        MatcherAssert.assertThat((Object)cache, (Matcher)Matchers.instanceOf(DefaultMetadataCache.class));
        ((ObjectStore)Mockito.verify(this.objectStore)).contains(SOME_KEY);
        ((ObjectStore)Mockito.verify(this.objectStore, (VerificationMode)Mockito.never())).retrieve(SOME_KEY);
        ((ObjectStore)Mockito.verify(this.objectStore)).store(SOME_KEY, (Serializable)cache);
    }

    @Test
    public void retrieveCacheWhenExists() throws ObjectStoreException {
        Mockito.when((Object)this.objectStore.contains(SOME_KEY)).thenReturn((Object)true);
        Mockito.when((Object)((MetadataCache)this.objectStore.retrieve(SOME_KEY))).thenReturn((Object)this.mockCache);
        MetadataCache actual = this.cacheManager.getOrCreateCache(SOME_KEY);
        MatcherAssert.assertThat((Object)actual, (Matcher)Matchers.is((Object)this.mockCache));
        ((ObjectStore)Mockito.verify(this.objectStore)).contains(SOME_KEY);
        ((ObjectStore)Mockito.verify(this.objectStore)).retrieve(SOME_KEY);
        ((ObjectStore)Mockito.verify(this.objectStore, (VerificationMode)Mockito.never())).store(ArgumentMatchers.anyString(), (Serializable)((MetadataCache)ArgumentMatchers.any(MetadataCache.class)));
    }

    @Test
    public void updateCache() throws ObjectStoreException {
        Mockito.when((Object)this.objectStore.contains(SOME_KEY)).thenReturn((Object)true);
        Mockito.when((Object)((MetadataCache)this.objectStore.remove(SOME_KEY))).thenReturn((Object)this.mockCache);
        DefaultMetadataCache cache = new DefaultMetadataCache();
        this.cacheManager.updateCache(SOME_KEY, (MetadataCache)cache);
        ((ObjectStore)Mockito.verify(this.objectStore)).contains(SOME_KEY);
        ((ObjectStore)Mockito.verify(this.objectStore)).remove(SOME_KEY);
        ((ObjectStore)Mockito.verify(this.objectStore)).store(SOME_KEY, (Serializable)cache);
        ((ObjectStore)Mockito.verify(this.objectStore, (VerificationMode)Mockito.never())).retrieve(SOME_KEY);
    }

    @Test
    public void disposeExactId() throws ObjectStoreException {
        Mockito.when((Object)((MetadataCache)this.objectStore.remove(SOME_KEY))).thenReturn((Object)this.mockCache);
        this.cacheManager.dispose(SOME_KEY);
        ((ObjectStore)Mockito.verify(this.objectStore)).remove(SOME_KEY);
        ((ObjectStore)Mockito.verify(this.objectStore, (VerificationMode)Mockito.never())).contains(SOME_KEY);
        ((ObjectStore)Mockito.verify(this.objectStore, (VerificationMode)Mockito.never())).retrieve(SOME_KEY);
    }

    @Test
    public void disposePartialId() throws ObjectStoreException {
        String partialId = "1874947571-1840879217";
        Mockito.when((Object)this.objectStore.allKeys()).thenReturn(Arrays.asList(SOME_KEY, OTHER_KEY));
        Mockito.when((Object)((MetadataCache)this.objectStore.remove("1874947571-1840879217"))).thenThrow(new Throwable[]{new ObjectDoesNotExistException()});
        this.cacheManager.dispose("1874947571-1840879217");
        ((ObjectStore)Mockito.verify(this.objectStore)).remove(SOME_KEY);
        ((ObjectStore)Mockito.verify(this.objectStore)).remove(OTHER_KEY);
    }

    @Test
    public void clearMetadataCaches() throws ObjectStoreException {
        this.cacheManager.dispose("");
        ((ObjectStore)Mockito.verify(this.objectStore)).clear();
    }
}

