/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.module.observability.configuration;

/**
 * Allows resolution of configuration properties that can be part of an {@link ObservabilitySignalConfiguration} values via
 * different implementations.
 *
 * @since 4.10
 */
public interface ObservabilitySignalConfigurationPropertyResolver {

  /**
   * Resolves a configuration property reference.
   *
   * @param propertyReference The property reference.
   * @return String with the resolved property value.
   */
  String resolve(String propertyReference);
}
