/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.module.observability.configuration;

import java.io.File;

/**
 * Allows to find an {@link ObservabilitySignalConfiguration} via different implementations.
 *
 * @since 4.10
 */
public interface ObservabilitySignalConfigurationFileFinder {

  /**
   * Returns an artifact resource file.
   *
   * @param path The path to the artifact resource file.
   * @return The file or null if the file is not present at the artifact resources.
   */
  File getResource(String path);

}
