/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.observability;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import org.mule.runtime.module.observability.configuration.ObservabilitySignalConfiguration;
import org.mule.runtime.module.observability.configuration.ObservabilitySignalConfigurationFileFinder;
import org.mule.runtime.module.observability.configuration.ObservabilitySignalConfigurationPropertyResolver;

public abstract class AbstractFileObservabilitySignalConfiguration
implements ObservabilitySignalConfiguration {
    private static final ObjectMapper configFileMapper = new ObjectMapper((JsonFactory)new YAMLFactory());
    private static final String UNSUPPORTED_TYPE_ERROR_MESSAGE = "Configuration key '%s' has an unsupported type %s. Only string values are allowed.";
    private final ObservabilitySignalConfigurationPropertyResolver observabilitySignalConfigurationPropertyResolver;
    private boolean isPropertiesInitialized = false;
    private JsonNode configuration;
    private File configurationFile;
    private final ObservabilitySignalConfigurationFileFinder artifactResourceFinder;

    protected AbstractFileObservabilitySignalConfiguration(ObservabilitySignalConfigurationFileFinder artifactResourceFinder, ObservabilitySignalConfigurationPropertyResolver observabilitySignalConfigurationPropertyResolver) {
        this.observabilitySignalConfigurationPropertyResolver = observabilitySignalConfigurationPropertyResolver;
        this.artifactResourceFinder = artifactResourceFinder;
    }

    protected abstract void onConfigurationFileNotFound();

    protected abstract void onConfigurationFileLoadError(Exception var1, File var2);

    protected abstract String getSignalConfigurationFileName();

    protected abstract Path getSignalConfigurationFileDirectoryPath();

    protected static File findArtifactConfigFile(ClassLoader executionClassloader, String configFilePath) {
        try {
            URL resource = executionClassloader.getResource(configFilePath);
            return resource != null ? new File(resource.toURI()) : null;
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    @Override
    public String getStringValue(String configurationKey) {
        String configurationValue;
        if (!this.isPropertiesInitialized) {
            this.initialise();
            this.isPropertiesInitialized = true;
        }
        if ((configurationValue = this.readStringFromConfigOrSystemProperty(configurationKey)) != null) {
            configurationValue = this.observabilitySignalConfigurationPropertyResolver.resolve(configurationValue);
        }
        return configurationValue;
    }

    @Override
    public Path getPathValue(String key, Path defaultValue) {
        return this.getAbsolutePath(ObservabilitySignalConfiguration.super.getPathValue(key, defaultValue));
    }

    protected void initialise() {
        this.loadConfiguration();
    }

    private void loadConfiguration() {
        try {
            this.configurationFile = this.getSignalConfigurationFromArtifactOrFromFileSystem();
            if (this.configurationFile.exists()) {
                this.parseConfiguration(this.configurationFile);
            } else {
                this.onConfigurationFileNotFound();
            }
        }
        catch (Exception configurationException) {
            this.onConfigurationFileLoadError(configurationException, this.configurationFile);
        }
    }

    private File getSignalConfigurationFromArtifactOrFromFileSystem() {
        return this.getSignalConfigurationResourceFromArtifactOrFromFileSystem(Path.of(this.getSignalConfigurationFileName(), new String[0]));
    }

    private File getSignalConfigurationResourceFromArtifactOrFromFileSystem(Path path) {
        File configurationFile = null;
        if (AbstractFileObservabilitySignalConfiguration.isApplicationLevelConfigurable()) {
            configurationFile = this.artifactResourceFinder.getResource(path.toString());
        }
        return configurationFile != null ? configurationFile : this.getSignalConfigurationFileDirectoryPath().resolve(path).toFile();
    }

    protected static boolean isApplicationLevelConfigurable() {
        return Boolean.getBoolean("mule.observability.configuration.enableConfigurationAtApplicationLevel") || Boolean.getBoolean("mule.tracing.configuration.enableTracerConfigurationAtApplicationLevel");
    }

    private String readStringFromConfigOrSystemProperty(String key) {
        if (this.configuration == null) {
            return System.getProperty(key);
        }
        JsonNode node = this.readFromConfiguration(key, this.configuration);
        if (node == null || node.isNull()) {
            return null;
        }
        if (!node.isValueNode()) {
            throw new IllegalArgumentException(String.format(UNSUPPORTED_TYPE_ERROR_MESSAGE, key, node.getNodeType()));
        }
        String value = node.asText();
        return !value.isEmpty() ? value : null;
    }

    private JsonNode readFromConfiguration(String key, JsonNode configuration) {
        String[] path = key.split("\\.");
        JsonNode node = configuration;
        for (String pathPart : path) {
            if ((node = node.get(pathPart)) != null) continue;
            return null;
        }
        return node;
    }

    private Path getAbsolutePath(Path path) {
        if (path.isAbsolute()) {
            return path;
        }
        File configurationFile = this.getSignalConfigurationResourceFromArtifactOrFromFileSystem(path);
        return configurationFile.toPath().toAbsolutePath();
    }

    private void parseConfiguration(File configurationFile) throws IOException {
        this.configuration = configFileMapper.readTree(configurationFile);
    }

    public File getConfigurationFile() {
        return this.configurationFile;
    }
}

