/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.config.internal.model.dsl.config;

import static java.util.Collections.singletonMap;

import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.core.Is.is;

import org.mule.tck.junit4.AbstractMuleTestCase;

import org.junit.jupiter.api.Test;

class EnvironmentPropertiesConfigurationProviderTestCase extends AbstractMuleTestCase {

  @Test
  void environmentVariables() {
    String variableKey = "varA";
    String variableValue = "varAValue";
    EnvironmentPropertiesConfigurationProvider environmentPropertiesConfigurationProvider =
        new EnvironmentPropertiesConfigurationProvider(() -> singletonMap(variableKey, variableValue));
    assertThat(environmentPropertiesConfigurationProvider.provide(variableKey).get().getValue(),
               is(variableValue));
  }

}
