/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.model.properties;

import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import org.mule.runtime.api.component.ConfigurationProperties;
import org.mule.runtime.api.config.Feature;
import org.mule.runtime.api.config.FeatureFlaggingService;
import org.mule.runtime.api.config.MuleRuntimeFeature;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.config.api.properties.ConfigurationPropertiesHierarchyBuilder;
import org.mule.runtime.config.api.properties.ConfigurationPropertiesResolver;
import org.mule.runtime.config.api.properties.PropertiesResolverUtils;
import org.mule.runtime.config.internal.dsl.model.config.PropertiesResolverConfigurationProperties;
import org.mule.runtime.properties.api.ConfigurationProperty;
import org.mule.runtime.properties.api.ResourceProvider;

public class PropertiesHierarchyCreationUtils {
    private PropertiesHierarchyCreationUtils() {
    }

    public static PropertiesResolverConfigurationProperties createConfigurationAttributeResolver(ArtifactAst artifactAst, Optional<ConfigurationProperties> parentConfigurationProperties, Map<String, String> deploymentProperties, ResourceProvider externalResourceProvider, Optional<FeatureFlaggingService> featureFlaggingService) {
        ConfigurationPropertiesHierarchyBuilder partialResolverBuilder = new ConfigurationPropertiesHierarchyBuilder();
        if (featureFlaggingService.orElse(f -> true).isEnabled((Feature)MuleRuntimeFeature.HONOUR_RESERVED_PROPERTIES)) {
            partialResolverBuilder.withDeploymentProperties(deploymentProperties);
        }
        Supplier<Map<String, ConfigurationProperty>> globalPropertiesSupplier = PropertiesResolverUtils.createGlobalPropertiesSupplier(artifactAst);
        ConfigurationPropertiesResolver partialResolver = partialResolverBuilder.withSystemProperties().withEnvironmentProperties().withGlobalPropertiesSupplier(globalPropertiesSupplier).build();
        artifactAst.updatePropertiesResolver((UnaryOperator)partialResolver);
        ConfigurationPropertiesHierarchyBuilder completeBuilder = new ConfigurationPropertiesHierarchyBuilder().withDeploymentProperties(deploymentProperties).withSystemProperties().withEnvironmentProperties().withPropertiesFile(externalResourceProvider).withGlobalPropertiesSupplier(globalPropertiesSupplier);
        PropertiesResolverUtils.getConfigurationPropertiesProvidersFromComponents(artifactAst, externalResourceProvider, partialResolver).forEach(completeBuilder::withApplicationProperties);
        parentConfigurationProperties.ifPresent(completeBuilder::withDomainPropertiesResolver);
        return new PropertiesResolverConfigurationProperties(completeBuilder.build());
    }

    public static PropertiesResolverConfigurationProperties createConfigurationAttributeResolver(Optional<ConfigurationProperties> parentConfigurationProperties, Map<String, String> deploymentProperties, ResourceProvider externalResourceProvider) {
        ConfigurationPropertiesHierarchyBuilder builder = new ConfigurationPropertiesHierarchyBuilder().withDeploymentProperties(deploymentProperties).withSystemProperties().withEnvironmentProperties().withPropertiesFile(externalResourceProvider);
        parentConfigurationProperties.ifPresent(builder::withDomainPropertiesResolver);
        return new PropertiesResolverConfigurationProperties(builder.build());
    }
}

