/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.api.properties;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.mule.runtime.api.component.ConfigurationProperties;
import org.mule.runtime.config.api.properties.ConfigurationPropertiesResolver;
import org.mule.runtime.config.internal.model.dsl.config.CompositeConfigurationPropertiesProvider;
import org.mule.runtime.config.internal.model.dsl.config.DefaultConfigurationPropertiesResolver;
import org.mule.runtime.config.internal.model.dsl.config.DefaultConfigurationProperty;
import org.mule.runtime.config.internal.model.dsl.config.EnvironmentPropertiesConfigurationProvider;
import org.mule.runtime.config.internal.model.dsl.config.FileConfigurationPropertiesProvider;
import org.mule.runtime.config.internal.model.dsl.config.GlobalPropertyConfigurationPropertiesProvider;
import org.mule.runtime.config.internal.model.dsl.config.MapConfigurationPropertiesProvider;
import org.mule.runtime.config.internal.model.dsl.config.SystemPropertiesConfigurationProvider;
import org.mule.runtime.properties.api.ConfigurationPropertiesProvider;
import org.mule.runtime.properties.api.ConfigurationProperty;
import org.mule.runtime.properties.api.ResourceProvider;

public class ConfigurationPropertiesHierarchyBuilder {
    private Optional<ConfigurationPropertiesProvider> deploymentProperties = Optional.empty();
    private Optional<ConfigurationPropertiesProvider> systemProperties = Optional.empty();
    private Optional<ConfigurationPropertiesProvider> environmentProperties = Optional.empty();
    private Optional<ConfigurationPropertiesProvider> fileProperties = Optional.empty();
    private Optional<ConfigurationPropertiesProvider> domainResolver = Optional.empty();
    private List<ConfigurationPropertiesProvider> appProperties = new ArrayList<ConfigurationPropertiesProvider>();
    private Supplier<Map<String, ConfigurationProperty>> globalPropertiesSupplier = HashMap::new;
    private boolean failuresIfNotPresent = true;

    public ConfigurationPropertiesHierarchyBuilder withDeploymentProperties(Map<String, String> properties) {
        if (!properties.isEmpty()) {
            this.deploymentProperties = Optional.of(new MapConfigurationPropertiesProvider(properties, "Deployment properties"));
        }
        return this;
    }

    public ConfigurationPropertiesHierarchyBuilder withSystemProperties() {
        this.systemProperties = Optional.of(new SystemPropertiesConfigurationProvider());
        return this;
    }

    public ConfigurationPropertiesHierarchyBuilder withEnvironmentProperties() {
        this.environmentProperties = Optional.of(new EnvironmentPropertiesConfigurationProvider());
        return this;
    }

    public ConfigurationPropertiesHierarchyBuilder withPropertiesFile(ResourceProvider resourceProvider) {
        this.fileProperties = Optional.of(new FileConfigurationPropertiesProvider(resourceProvider, "External Files"));
        return this;
    }

    public ConfigurationPropertiesHierarchyBuilder withApplicationProperties(ConfigurationPropertiesProvider provider) {
        this.appProperties.add(provider);
        return this;
    }

    public ConfigurationPropertiesHierarchyBuilder withGlobalPropertiesSupplier(Supplier<Map<String, ConfigurationProperty>> globalPropertiesSupplier) {
        this.globalPropertiesSupplier = globalPropertiesSupplier;
        return this;
    }

    public ConfigurationPropertiesHierarchyBuilder withDomainPropertiesResolver(final ConfigurationProperties domainProperties) {
        this.domainResolver = Optional.of(new ConfigurationPropertiesProvider(){

            public Optional<ConfigurationProperty> provide(String configurationAttributeKey) {
                return domainProperties.resolveProperty(configurationAttributeKey).map(value -> new DefaultConfigurationProperty(ConfigurationPropertiesHierarchyBuilder.this.domainResolver, configurationAttributeKey, value));
            }

            public String getDescription() {
                return "Domain properties";
            }
        });
        return this;
    }

    public ConfigurationPropertiesHierarchyBuilder withoutFailuresIfPropertyNotPresent() {
        this.failuresIfNotPresent = false;
        return this;
    }

    private void addToHierarchy(ArrayDeque<DefaultConfigurationPropertiesResolver> hierarchy, ConfigurationPropertiesProvider newProvider) {
        Optional<ConfigurationPropertiesResolver> nextResolver = hierarchy.isEmpty() ? Optional.empty() : Optional.of((ConfigurationPropertiesResolver)hierarchy.peek());
        hierarchy.push(new DefaultConfigurationPropertiesResolver(nextResolver, newProvider, this.failuresIfNotPresent));
    }

    public ConfigurationPropertiesResolver build() {
        ArrayDeque<DefaultConfigurationPropertiesResolver> hierarchy = new ArrayDeque<DefaultConfigurationPropertiesResolver>();
        this.addToHierarchy(hierarchy, new GlobalPropertyConfigurationPropertiesProvider(this.globalPropertiesSupplier));
        this.domainResolver.ifPresent(provider -> this.addToHierarchy(hierarchy, (ConfigurationPropertiesProvider)provider));
        if (!this.appProperties.isEmpty()) {
            this.addToHierarchy(hierarchy, new CompositeConfigurationPropertiesProvider(this.appProperties));
        }
        this.fileProperties.ifPresent(provider -> this.addToHierarchy(hierarchy, (ConfigurationPropertiesProvider)provider));
        this.environmentProperties.ifPresent(provider -> this.addToHierarchy(hierarchy, (ConfigurationPropertiesProvider)provider));
        this.systemProperties.ifPresent(provider -> this.addToHierarchy(hierarchy, (ConfigurationPropertiesProvider)provider));
        this.deploymentProperties.ifPresent(provider -> this.addToHierarchy(hierarchy, (ConfigurationPropertiesProvider)provider));
        DefaultConfigurationPropertiesResolver lastResolver = hierarchy.peek();
        lastResolver.setAsRootResolver();
        return lastResolver;
    }

    @Deprecated
    public ConfigurationPropertiesResolver buildLegacyHierarchy() {
        ArrayDeque<DefaultConfigurationPropertiesResolver> hierarchy = new ArrayDeque<DefaultConfigurationPropertiesResolver>();
        this.deploymentProperties.ifPresent(provider -> this.addToHierarchy(hierarchy, (ConfigurationPropertiesProvider)provider));
        this.addToHierarchy(hierarchy, new GlobalPropertyConfigurationPropertiesProvider(this.globalPropertiesSupplier));
        this.domainResolver.ifPresent(provider -> this.addToHierarchy(hierarchy, (ConfigurationPropertiesProvider)provider));
        if (!this.appProperties.isEmpty()) {
            this.addToHierarchy(hierarchy, new CompositeConfigurationPropertiesProvider(this.appProperties));
        }
        this.fileProperties.ifPresent(provider -> this.addToHierarchy(hierarchy, (ConfigurationPropertiesProvider)provider));
        this.environmentProperties.ifPresent(provider -> this.addToHierarchy(hierarchy, (ConfigurationPropertiesProvider)provider));
        this.systemProperties.ifPresent(provider -> this.addToHierarchy(hierarchy, (ConfigurationPropertiesProvider)provider));
        return hierarchy.peek();
    }
}

