/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.model.dsl.config;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.mule.runtime.config.internal.model.dsl.config.DefaultConfigurationProperty;
import org.mule.runtime.properties.api.ConfigurationPropertiesProvider;
import org.mule.runtime.properties.api.ConfigurationProperty;

public class EnvironmentPropertiesConfigurationProvider
implements ConfigurationPropertiesProvider {
    private final Map<String, ConfigurationProperty> configurationAttributes = new HashMap<String, ConfigurationProperty>();

    public EnvironmentPropertiesConfigurationProvider() {
        this(System::getenv);
    }

    EnvironmentPropertiesConfigurationProvider(Supplier<Map<String, String>> environmentVariablesSupplier) {
        Map<String, String> environmentVariables = environmentVariablesSupplier.get();
        environmentVariables.entrySet().forEach(entry -> this.configurationAttributes.put((String)entry.getKey(), new DefaultConfigurationProperty("environment variable", (String)entry.getKey(), entry.getValue())));
    }

    public Optional<ConfigurationProperty> provide(String configurationAttributeKey) {
        return Optional.ofNullable(this.configurationAttributes.get(configurationAttributeKey));
    }

    public String getDescription() {
        return "environment properties provider";
    }
}

