/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.reboot.internal;

import org.mule.runtime.module.reboot.internal.MuleContainerWrapper;

public class MuleContainerWrapperProvider {
    private static final String MULE_BOOTSTRAP_CONTAINER_WRAPPER_CLASS_SYSTEM_PROPERTY = "mule.bootstrap.container.wrapper.class";
    private static MuleContainerWrapper INSTANCE;

    public static MuleContainerWrapper getMuleContainerWrapper() {
        if (INSTANCE == null) {
            INSTANCE = MuleContainerWrapperProvider.createContainerWrapper();
        }
        return INSTANCE;
    }

    private static MuleContainerWrapper createContainerWrapper() {
        String wrapperClassName = System.getProperty(MULE_BOOTSTRAP_CONTAINER_WRAPPER_CLASS_SYSTEM_PROPERTY);
        if (wrapperClassName == null) {
            throw new RuntimeException(String.format("System property '%s' is not defined, it must be set with an implementation of %s", MULE_BOOTSTRAP_CONTAINER_WRAPPER_CLASS_SYSTEM_PROPERTY, MuleContainerWrapper.class.getName()));
        }
        try {
            Class<?> wrapperClass = MuleContainerWrapper.class.getClassLoader().loadClass(wrapperClassName);
            if (!MuleContainerWrapper.class.isAssignableFrom(wrapperClass)) {
                throw new RuntimeException(String.format("System property '%s=%s' does not define an implementation of %s", MULE_BOOTSTRAP_CONTAINER_WRAPPER_CLASS_SYSTEM_PROPERTY, wrapperClassName, MuleContainerWrapper.class.getName()));
            }
            return (MuleContainerWrapper)wrapperClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(String.format("Unable to instantiate MuleContainerWrapper implementation '%s' from system property '%s'", wrapperClassName, MULE_BOOTSTRAP_CONTAINER_WRAPPER_CLASS_SYSTEM_PROPERTY), e);
        }
    }
}

