/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.service;

import java.lang.reflect.Proxy;
import java.util.ArrayList;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.junit.Test;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.api.service.Service;
import org.mule.runtime.module.service.MuleServiceManager;
import org.mule.runtime.module.service.ServiceDiscoverer;
import org.mule.tck.junit4.AbstractMuleTestCase;

public class MuleServiceManagerTestCase
extends AbstractMuleTestCase {
    @Test
    public void registerServices() throws Exception {
        ServiceDiscoverer serviceDiscoverer = (ServiceDiscoverer)Mockito.mock(ServiceDiscoverer.class);
        ArrayList<Service> services = new ArrayList<Service>();
        Service service1 = (Service)Mockito.mock(Service.class);
        Service service2 = (Service)Mockito.mock(Service.class);
        services.add(service1);
        services.add(service2);
        Mockito.when((Object)serviceDiscoverer.discoverServices()).thenReturn(services);
        MuleServiceManager muleServiceManager = new MuleServiceManager(serviceDiscoverer);
        muleServiceManager.start();
        MatcherAssert.assertThat((Object)muleServiceManager.getServices().size(), (Matcher)Matchers.equalTo((Object)2));
        MatcherAssert.assertThat(muleServiceManager.getServices().get(0), (Matcher)Matchers.equalTo((Object)service1));
        MatcherAssert.assertThat(muleServiceManager.getServices().get(1), (Matcher)Matchers.equalTo((Object)service2));
    }

    @Test
    public void startServices() throws Exception {
        ServiceDiscoverer serviceDiscoverer = (ServiceDiscoverer)Mockito.mock(ServiceDiscoverer.class);
        ArrayList<StartableService> services = new ArrayList<StartableService>();
        StartableService service1 = (StartableService)Mockito.mock(StartableService.class);
        StartableService service2 = (StartableService)Mockito.mock(StartableService.class);
        services.add(service1);
        services.add(service2);
        Mockito.when((Object)serviceDiscoverer.discoverServices()).thenReturn(services);
        MuleServiceManager muleServiceManager = new MuleServiceManager(serviceDiscoverer);
        muleServiceManager.start();
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{service1, service2});
        ((StartableService)inOrder.verify((Object)service1)).start();
        ((StartableService)inOrder.verify((Object)service2)).start();
    }

    @Test
    public void stopsServices() throws Exception {
        ServiceDiscoverer serviceDiscoverer = (ServiceDiscoverer)Mockito.mock(ServiceDiscoverer.class);
        ArrayList<StoppableService> services = new ArrayList<StoppableService>();
        StoppableService service1 = (StoppableService)Mockito.mock(StoppableService.class);
        StoppableService service2 = (StoppableService)Mockito.mock(StoppableService.class);
        services.add(service1);
        services.add(service2);
        Mockito.when((Object)serviceDiscoverer.discoverServices()).thenReturn(services);
        MuleServiceManager muleServiceManager = new MuleServiceManager(serviceDiscoverer);
        muleServiceManager.start();
        muleServiceManager.stop();
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{service1, service2});
        ((StoppableService)inOrder.verify((Object)service2)).stop();
        ((StoppableService)inOrder.verify((Object)service1)).stop();
    }

    @Test
    public void ignoresServiceStopError() throws Exception {
        ServiceDiscoverer serviceDiscoverer = (ServiceDiscoverer)Mockito.mock(ServiceDiscoverer.class);
        ArrayList<StoppableService> services = new ArrayList<StoppableService>();
        StoppableService service1 = (StoppableService)Mockito.mock(StoppableService.class);
        ((StoppableService)Mockito.doThrow((Throwable)new RuntimeException()).when((Object)service1)).stop();
        StoppableService service2 = (StoppableService)Mockito.mock(StoppableService.class);
        ((StoppableService)Mockito.doThrow((Throwable)new RuntimeException()).when((Object)service2)).stop();
        services.add(service1);
        services.add(service2);
        Mockito.when((Object)serviceDiscoverer.discoverServices()).thenReturn(services);
        MuleServiceManager muleServiceManager = new MuleServiceManager(serviceDiscoverer);
        muleServiceManager.start();
        muleServiceManager.stop();
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{service1, service2});
        ((StoppableService)inOrder.verify((Object)service2)).stop();
        ((StoppableService)inOrder.verify((Object)service1)).stop();
    }

    @Test
    public void wrapsServices() throws Exception {
        ServiceDiscoverer serviceDiscoverer = (ServiceDiscoverer)Mockito.mock(ServiceDiscoverer.class);
        ArrayList<StoppableService> services = new ArrayList<StoppableService>();
        StoppableService service1 = (StoppableService)Mockito.mock(StoppableService.class);
        services.add(service1);
        Mockito.when((Object)serviceDiscoverer.discoverServices()).thenReturn(services);
        MuleServiceManager muleServiceManager = new MuleServiceManager(serviceDiscoverer);
        muleServiceManager.start();
        MatcherAssert.assertThat((Object)Proxy.isProxyClass(((Service)muleServiceManager.getServices().get(0)).getClass()), (Matcher)Is.is((Object)true));
    }

    public static interface StoppableService
    extends Service,
    Stoppable {
    }

    public static interface StartableService
    extends Service,
    Startable {
    }
}

