/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.service;

import java.io.File;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.mule.runtime.container.api.MuleFoldersUtil;
import org.mule.runtime.core.api.util.FileUtils;
import org.mule.runtime.module.service.ServiceDescriptor;
import org.mule.runtime.module.service.ServiceDescriptorFactory;
import org.mule.runtime.module.service.builder.ServiceFileBuilder;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.junit4.rule.SystemPropertyTemporaryFolder;

public class ServiceDescriptorFactoryTestCase
extends AbstractMuleTestCase {
    public static final String SERVICE_NAME = "testService";
    public static final String PROVIDER_CLASS_NAME = "org.foo.FooServiceProvider";
    private final ServiceDescriptorFactory serviceDescriptorFactory = new ServiceDescriptorFactory();
    @Rule
    public TemporaryFolder muleHome = new SystemPropertyTemporaryFolder("mule.home");

    @Test
    public void createServiceDescriptor() throws Exception {
        File servicesFolder = MuleFoldersUtil.getServicesFolder();
        MatcherAssert.assertThat((Object)servicesFolder.mkdirs(), (Matcher)Is.is((Object)true));
        ServiceFileBuilder fooService = new ServiceFileBuilder(SERVICE_NAME).configuredWith("service.className", PROVIDER_CLASS_NAME);
        FileUtils.unzip((File)fooService.getArtifactFile(), (File)MuleFoldersUtil.getServiceFolder((String)SERVICE_NAME));
        ServiceDescriptor descriptor = this.serviceDescriptorFactory.create(MuleFoldersUtil.getServiceFolder((String)SERVICE_NAME));
        MatcherAssert.assertThat((Object)descriptor.getName(), (Matcher)Matchers.equalTo((Object)SERVICE_NAME));
        MatcherAssert.assertThat((Object)descriptor.getServiceProviderClassName(), (Matcher)Matchers.equalTo((Object)PROVIDER_CLASS_NAME));
        MatcherAssert.assertThat((Object)descriptor.getRootFolder(), (Matcher)Matchers.equalTo((Object)MuleFoldersUtil.getServiceFolder((String)SERVICE_NAME)));
    }
}

