/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.service;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Properties;
import org.mule.runtime.module.artifact.descriptor.ArtifactDescriptorCreateException;
import org.mule.runtime.module.artifact.descriptor.ArtifactDescriptorFactory;
import org.mule.runtime.module.service.ServiceDescriptor;

public class ServiceDescriptorFactory
implements ArtifactDescriptorFactory<ServiceDescriptor> {
    public static final String SERVICE_PROVIDER_CLASS_NAME = "service.className";

    public ServiceDescriptor create(File artifactFolder) throws ArtifactDescriptorCreateException {
        if (!artifactFolder.exists()) {
            throw new IllegalArgumentException("Service folder does not exists: " + artifactFolder.getAbsolutePath());
        }
        String serviceName = artifactFolder.getName();
        ServiceDescriptor descriptor = new ServiceDescriptor(serviceName);
        descriptor.setRootFolder(artifactFolder);
        File servicePropsFile = new File(artifactFolder, "service.properties");
        if (!servicePropsFile.exists()) {
            throw new ArtifactDescriptorCreateException("Service must contain a service.properties file");
        }
        Properties props = new Properties();
        try {
            props.load(new FileReader(servicePropsFile));
        }
        catch (IOException e) {
            throw new ArtifactDescriptorCreateException("Cannot read service.properties file", (Throwable)e);
        }
        descriptor.setServiceProviderClassName(props.getProperty(SERVICE_PROVIDER_CLASS_NAME));
        return descriptor;
    }
}

