/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.service;

import java.util.ArrayList;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.runtime.module.service.DefaultServiceDiscoverer;
import org.mule.runtime.module.service.ServiceProviderDiscoverer;
import org.mule.runtime.module.service.ServiceResolutionError;
import org.mule.runtime.module.service.ServiceResolver;
import org.mule.tck.junit4.AbstractMuleTestCase;

public class DefaultServiceDiscovererTestCase
extends AbstractMuleTestCase {
    private final ServiceResolver serviceResolver = (ServiceResolver)Mockito.mock(ServiceResolver.class);
    private final ServiceProviderDiscoverer serviceProviderDiscoverer = (ServiceProviderDiscoverer)Mockito.mock(ServiceProviderDiscoverer.class);
    private final DefaultServiceDiscoverer serviceDiscoverer = new DefaultServiceDiscoverer(this.serviceProviderDiscoverer, this.serviceResolver);

    @Test
    public void discoversServices() throws Exception {
        ArrayList serviceProviders = new ArrayList();
        Mockito.when((Object)this.serviceProviderDiscoverer.discover()).thenReturn(serviceProviders);
        ArrayList expectedServices = new ArrayList();
        Mockito.when((Object)this.serviceResolver.resolveServices(serviceProviders)).thenReturn(expectedServices);
        List services = this.serviceDiscoverer.discoverServices();
        MatcherAssert.assertThat((Object)services, (Matcher)Matchers.is(expectedServices));
    }

    @Test(expected=ServiceResolutionError.class)
    public void propagatesDiscoverErrors() throws Exception {
        Mockito.when((Object)this.serviceProviderDiscoverer.discover()).thenThrow(new Throwable[]{new ServiceResolutionError("Error")});
        this.serviceDiscoverer.discoverServices();
    }

    @Test(expected=ServiceResolutionError.class)
    public void propagatesServiceResolutionErrors() throws Exception {
        ArrayList serviceProviders = new ArrayList();
        Mockito.when((Object)this.serviceProviderDiscoverer.discover()).thenReturn(serviceProviders);
        Mockito.when((Object)this.serviceResolver.resolveServices(serviceProviders)).thenThrow(new Throwable[]{new ServiceResolutionError("Error")});
        this.serviceDiscoverer.discoverServices();
    }
}

