/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.service.builder;

import com.google.common.base.Preconditions;
import java.io.File;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.mule.runtime.core.api.util.StringUtils;
import org.mule.runtime.module.artifact.builder.AbstractArtifactFileBuilder;
import org.mule.tck.ZipUtils;

public class ServiceFileBuilder
extends AbstractArtifactFileBuilder<ServiceFileBuilder> {
    private Properties properties = new Properties();

    public ServiceFileBuilder(String id) {
        super(id);
    }

    public ServiceFileBuilder(ServiceFileBuilder source) {
        super((AbstractArtifactFileBuilder)source);
    }

    public ServiceFileBuilder(String id, ServiceFileBuilder source) {
        super(id, (AbstractArtifactFileBuilder)source);
        this.properties.putAll((Map<?, ?>)source.properties);
    }

    protected String getFileExtension() {
        return ".zip";
    }

    protected ServiceFileBuilder getThis() {
        return this;
    }

    public ServiceFileBuilder configuredWith(String propertyName, String propertyValue) {
        this.checkImmutable();
        Preconditions.checkArgument((!StringUtils.isEmpty((String)propertyName) ? 1 : 0) != 0, (Object)"Property name cannot be empty");
        Preconditions.checkArgument((propertyValue != null ? 1 : 0) != 0, (Object)"Property value cannot be null");
        this.properties.put(propertyName, propertyValue);
        return this;
    }

    protected List<ZipUtils.ZipResource> getCustomResources() {
        LinkedList<ZipUtils.ZipResource> customResources = new LinkedList<ZipUtils.ZipResource>();
        if (!this.properties.isEmpty()) {
            File applicationPropertiesFile = new File(this.getTempFolder(), "service.properties");
            applicationPropertiesFile.deleteOnExit();
            this.createPropertiesFile(applicationPropertiesFile, this.properties);
            customResources.add(new ZipUtils.ZipResource(applicationPropertiesFile.getAbsolutePath(), "service.properties"));
        }
        return customResources;
    }

    public String getConfigFile() {
        return null;
    }
}

