/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.service.internal.artifact;

import java.io.File;
import java.util.Optional;
import java.util.Properties;
import org.mule.runtime.api.deployment.meta.MuleServiceModel;
import org.mule.runtime.api.deployment.persistence.AbstractMuleArtifactModelJsonSerializer;
import org.mule.runtime.api.deployment.persistence.MuleServiceModelJsonSerializer;
import org.mule.runtime.core.api.config.bootstrap.ArtifactType;
import org.mule.runtime.module.artifact.api.descriptor.AbstractArtifactDescriptorFactory;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptorCreateException;
import org.mule.runtime.module.artifact.api.descriptor.DescriptorLoaderRepository;
import org.mule.runtime.module.service.internal.artifact.ServiceDescriptor;

public class ServiceDescriptorFactory
extends AbstractArtifactDescriptorFactory<MuleServiceModel, ServiceDescriptor> {
    public ServiceDescriptorFactory(DescriptorLoaderRepository descriptorLoaderRepository) {
        super(descriptorLoaderRepository);
    }

    protected ArtifactType getArtifactType() {
        return ArtifactType.SERVICE;
    }

    public ServiceDescriptor create(File artifactFolder, Optional<Properties> properties) throws ArtifactDescriptorCreateException {
        if (!artifactFolder.exists()) {
            throw new IllegalArgumentException("Service folder does not exists: " + artifactFolder.getAbsolutePath());
        }
        return (ServiceDescriptor)super.create(artifactFolder, properties);
    }

    protected void validateVersion(ServiceDescriptor descriptor) {
        if (descriptor.getBundleDescriptor() != null) {
            super.validateVersion((ArtifactDescriptor)descriptor);
        }
    }

    protected void doDescriptorConfig(MuleServiceModel artifactModel, ServiceDescriptor descriptor, File artifactLocation) {
        descriptor.setServiceProviderClassName(artifactModel.getServiceProviderClassName());
    }

    protected ServiceDescriptor createArtifactDescriptor(File artifactLocation, String name, Optional<Properties> properties) {
        return new ServiceDescriptor(name, properties);
    }

    protected AbstractMuleArtifactModelJsonSerializer<MuleServiceModel> getMuleArtifactModelJsonSerializer() {
        return new MuleServiceModelJsonSerializer();
    }
}

