/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.service.internal.artifact;

import java.io.File;
import java.net.URL;
import java.util.Collections;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.collection.IsArrayContaining;
import org.hamcrest.collection.IsArrayWithSize;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mule.runtime.core.api.config.bootstrap.ArtifactType;
import org.mule.runtime.module.artifact.api.classloader.ClassLoaderLookupPolicy;
import org.mule.runtime.module.artifact.api.classloader.ParentFirstLookupStrategy;
import org.mule.runtime.module.artifact.api.descriptor.ClassLoaderModel;
import org.mule.runtime.module.service.internal.artifact.LibFolderClassLoaderModelLoader;
import org.mule.runtime.module.service.internal.artifact.ServiceDescriptor;
import org.mule.tck.junit4.AbstractMuleTestCase;

public class LibFolderClassLoaderModelLoaderTestCase
extends AbstractMuleTestCase {
    private final ClassLoaderLookupPolicy lookupPolicy = (ClassLoaderLookupPolicy)Mockito.mock(ClassLoaderLookupPolicy.class);
    @Rule
    public TemporaryFolder serviceFolder = new TemporaryFolder();
    private LibFolderClassLoaderModelLoader classLoaderModelLoader = new LibFolderClassLoaderModelLoader();
    private ServiceDescriptor descriptor;

    @Before
    public void setUp() throws Exception {
        this.descriptor = new ServiceDescriptor("testService");
        this.descriptor.setRootFolder(this.serviceFolder.getRoot());
        Mockito.when((Object)this.lookupPolicy.getClassLookupStrategy(Matchers.anyString())).thenReturn((Object)ParentFirstLookupStrategy.PARENT_FIRST);
    }

    @Test(expected=IllegalArgumentException.class)
    public void validatesServiceFolder() throws Exception {
        File fakeServiceFolder = new File("./fake/folder/for/test");
        this.descriptor.setRootFolder(fakeServiceFolder);
        this.classLoaderModelLoader.load(fakeServiceFolder, Collections.emptyMap(), ArtifactType.SERVICE);
    }

    @Test
    public void addsArtifactFolderToClassLoader() throws Exception {
        ClassLoaderModel classLoaderModel = this.classLoaderModelLoader.load(this.serviceFolder.getRoot(), Collections.emptyMap(), ArtifactType.SERVICE);
        URL[] urls = classLoaderModel.getUrls();
        MatcherAssert.assertThat((Object)urls, (Matcher)IsArrayWithSize.arrayWithSize((int)1));
        MatcherAssert.assertThat((Object)urls, (Matcher)IsArrayContaining.hasItemInArray((Object)this.serviceFolder.getRoot().toURI().toURL()));
    }

    @Test
    public void addJarsFromLibFolderToClassLoader() throws Exception {
        File libFolder = this.serviceFolder.newFolder("lib");
        File jarFile = new File(libFolder, "dummy.jar");
        jarFile.createNewFile();
        ClassLoaderModel classLoaderModel = this.classLoaderModelLoader.load(this.serviceFolder.getRoot(), Collections.emptyMap(), ArtifactType.SERVICE);
        URL[] urls = classLoaderModel.getUrls();
        MatcherAssert.assertThat((Object)urls, (Matcher)IsArrayWithSize.arrayWithSize((int)2));
        MatcherAssert.assertThat((Object)urls, (Matcher)IsArrayContaining.hasItemInArray((Object)jarFile.toURI().toURL()));
    }

    @Test
    public void ignoresNonJarsFilesFromLibFolder() throws Exception {
        File libFolder = this.serviceFolder.newFolder("lib");
        File jarFile = new File(libFolder, "dummy.txt");
        jarFile.createNewFile();
        ClassLoaderModel classLoaderModel = this.classLoaderModelLoader.load(this.serviceFolder.getRoot(), Collections.emptyMap(), ArtifactType.SERVICE);
        MatcherAssert.assertThat((Object)classLoaderModel.getUrls(), (Matcher)IsArrayContaining.hasItemInArray((Object)this.serviceFolder.getRoot().toURI().toURL()));
    }
}

