/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.service.internal.test.artifact;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Before;
import org.junit.Test;
import org.mule.runtime.module.service.internal.artifact.ModuleLayerGraph;

public class ModuleLayerGraphTestCase {
    private static final String GRAPH_REPR = "--------------\n| testLayer  |\n--------------\n       |\n       |\n       V\n--------------\n|testParentLayer|\n--------------\n";
    private ModuleLayerGraph graph;

    @Before
    public void setUp() throws Exception {
        ModuleLayer layer = this.getClass().getModule().getLayer();
        ModuleLayerGraph.setModuleLayerId((ModuleLayer)this.getClass().getModule().getLayer(), (String)"testLayer");
        ModuleLayerGraph.setModuleLayerId((ModuleLayer)layer.parents().get(0), (String)"testParentLayer");
        this.graph = new ModuleLayerGraph(layer);
    }

    @Test
    public void graphString() {
        MatcherAssert.assertThat((Object)this.graph.graphString(), (Matcher)CoreMatchers.is((Object)GRAPH_REPR));
    }

    @Test
    public void moduleLayerModules() {
        String info = this.graph.moduleLayerModules();
        MatcherAssert.assertThat((Object)info, (Matcher)CoreMatchers.containsString((String)"org.mule.runtime.metadata.model.api"));
        MatcherAssert.assertThat((Object)info, (Matcher)CoreMatchers.containsString((String)"org.mule.runtime.jpms.utils"));
        MatcherAssert.assertThat((Object)info, (Matcher)CoreMatchers.containsString((String)"org.mule.runtime.metrics.api"));
        MatcherAssert.assertThat((Object)info, (Matcher)CoreMatchers.containsString((String)"org.mule.runtime.tracer.api"));
        MatcherAssert.assertThat((Object)info, (Matcher)CoreMatchers.containsString((String)"org.mule.runtime.manifest"));
        MatcherAssert.assertThat((Object)info, (Matcher)CoreMatchers.containsString((String)"org.mule.runtime.dsl.api"));
        MatcherAssert.assertThat((Object)info, (Matcher)CoreMatchers.containsString((String)"org.mule.runtime.jar.handling.utils"));
        MatcherAssert.assertThat((Object)info, (Matcher)CoreMatchers.containsString((String)"org.mule.runtime.container"));
        MatcherAssert.assertThat((Object)info, (Matcher)CoreMatchers.containsString((String)"org.mule.runtime.metadata.model.message"));
        MatcherAssert.assertThat((Object)info, (Matcher)CoreMatchers.containsString((String)"org.mule.runtime.profiling.api"));
        MatcherAssert.assertThat((Object)info, (Matcher)CoreMatchers.containsString((String)"org.mule.runtime.tracer.customization.api"));
        MatcherAssert.assertThat((Object)info, (Matcher)CoreMatchers.containsString((String)"org.mule.runtime.tracer.exporter.configuration.api"));
        MatcherAssert.assertThat((Object)info, (Matcher)CoreMatchers.containsString((String)"org.mule.runtime.policy.api"));
        MatcherAssert.assertThat((Object)info, (Matcher)CoreMatchers.containsString((String)"org.mule.runtime.policy.api"));
        MatcherAssert.assertThat((Object)info, (Matcher)CoreMatchers.containsString((String)"org.mule.runtime.core"));
        MatcherAssert.assertThat((Object)info, (Matcher)CoreMatchers.containsString((String)"org.mule.runtime.metadata.model.java"));
        MatcherAssert.assertThat((Object)info, (Matcher)CoreMatchers.containsString((String)"org.mule.runtime.artifact.declaration"));
        MatcherAssert.assertThat((Object)info, (Matcher)CoreMatchers.containsString((String)"org.mule.runtime.errors"));
        MatcherAssert.assertThat((Object)info, (Matcher)CoreMatchers.containsString((String)"org.mule.sdk.api"));
    }
}

