/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.service.internal.manager;

import jakarta.inject.Inject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import org.mule.runtime.api.service.Service;
import org.mule.runtime.api.service.ServiceProvider;
import org.mule.runtime.module.service.api.discoverer.ServiceResolutionError;
import org.mule.runtime.module.service.api.manager.ServiceRegistry;
import org.reflections.ReflectionUtils;
import org.reflections.util.ReflectionUtilsPredicates;

public class DefaultServiceRegistry
implements ServiceRegistry {
    private final Map<Class<? extends Service>, Service> services = new HashMap<Class<? extends Service>, Service>();

    public void inject(ServiceProvider serviceProvider) throws ServiceResolutionError {
        Object dependency;
        Type type;
        boolean asOptional;
        Class dependencyType;
        for (Field field : ReflectionUtils.getAllFields(serviceProvider.getClass(), (Predicate[])new Predicate[]{ReflectionUtilsPredicates.withAnnotation(Inject.class)})) {
            dependencyType = field.getType();
            asOptional = false;
            if (dependencyType.equals(Optional.class)) {
                type = ((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0];
                dependencyType = type instanceof ParameterizedType ? (Class)((ParameterizedType)type).getRawType() : (Class)type;
                asOptional = true;
            }
            try {
                field.setAccessible(true);
                dependency = this.resolveObjectToInject(dependencyType, asOptional);
                if (dependency != null) {
                    field.set(serviceProvider, dependency);
                    continue;
                }
                if (asOptional) continue;
                throw new ServiceResolutionError(String.format("Cannot find a service to inject into field '%s#%s' of service provider '%s'", field.getDeclaringClass().getName(), field.getName(), serviceProvider.getServiceDefinition().getServiceClass().getName()));
            }
            catch (Exception e) {
                throw new ServiceResolutionError(String.format("Could not inject dependency on field '%s#%s' of type '%s'", field.getDeclaringClass().getName(), field.getName(), dependencyType.getName()), e);
            }
        }
        for (Method method : ReflectionUtils.getAllMethods(serviceProvider.getClass(), (Predicate[])new Predicate[]{ReflectionUtilsPredicates.withAnnotation(Inject.class)})) {
            if (method.getParameters().length != 1) continue;
            try {
                dependencyType = method.getParameterTypes()[0];
                asOptional = false;
                if (dependencyType.equals(Optional.class)) {
                    type = ((ParameterizedType)method.getGenericParameterTypes()[0]).getActualTypeArguments()[0];
                    dependencyType = type instanceof ParameterizedType ? (Class)((ParameterizedType)type).getRawType() : (Class)type;
                    asOptional = true;
                }
                if ((dependency = this.resolveObjectToInject(dependencyType, asOptional)) != null) {
                    method.invoke((Object)serviceProvider, dependency);
                    continue;
                }
                if (asOptional) continue;
                throw new ServiceResolutionError(String.format("Cannot find a service to inject into field '%s#%s' of service provider '%s'", method.getDeclaringClass().getName(), method.getName(), serviceProvider.getServiceDefinition().getServiceClass().getName()));
            }
            catch (Exception e) {
                throw new RuntimeException(String.format("Could not inject dependency on method %s of type %s", method.getName(), serviceProvider.getClass().getName()), e);
            }
        }
    }

    private Object resolveObjectToInject(Class<?> dependencyType, boolean asOptional) {
        Optional<Object> dependency = this.services.entrySet().stream().filter(entry -> dependencyType.isAssignableFrom((Class)entry.getKey())).findFirst().map(Map.Entry::getValue).orElse(null);
        return asOptional ? Optional.ofNullable(dependency) : dependency;
    }

    @Override
    public <S extends Service> void register(S service, Class<? extends S> serviceContract) {
        this.services.put(serviceContract, service);
    }

    public <S extends Service> void register(Class<? extends S> serviceContract, S service) {
        this.services.put(serviceContract, service);
    }

    @Override
    public <S extends Service> void unregister(Class<? extends S> serviceContract) {
        this.services.remove(serviceContract);
    }

    @Override
    public <S extends Service> Optional<S> getService(Class<? extends S> serviceInterface) {
        return this.services.values().stream().filter(serviceInterface::isInstance).map(s -> s).findAny();
    }

    @Override
    public Collection<Service> getAllServices() {
        return new HashSet<Service>(this.services.values());
    }
}

