/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.service.internal.test.discoverer;

import jakarta.inject.Inject;
import java.util.Optional;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsInstanceOf;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mule.runtime.api.service.Service;
import org.mule.runtime.api.service.ServiceDefinition;
import org.mule.runtime.api.service.ServiceProvider;
import org.mule.runtime.module.service.api.discoverer.ServiceResolutionError;
import org.mule.runtime.module.service.api.manager.ServiceRegistry;
import org.mule.runtime.module.service.internal.manager.DefaultServiceRegistry;
import org.mule.tck.junit4.AbstractMuleTestCase;

public class ServiceRegistryTestCase
extends AbstractMuleTestCase {
    private final DefaultServiceRegistry serviceRegistry = new DefaultServiceRegistry();

    @Test
    void injectsDependencies() throws Exception {
        FooService service = this.mockFooService();
        InjectableServiceProvider serviceProvider = new InjectableServiceProvider();
        this.serviceRegistry.inject((ServiceProvider)serviceProvider);
        MatcherAssert.assertThat((Object)serviceProvider.fooService, (Matcher)Is.is((Object)service));
    }

    private FooService mockFooService() {
        FooService service = (FooService)Mockito.mock(FooService.class);
        this.serviceRegistry.register((Service)service, FooService.class);
        return service;
    }

    @Test
    void detectsMissingDependency() throws Exception {
        InjectableServiceProvider serviceProvider = new InjectableServiceProvider();
        Assertions.assertThrows(ServiceResolutionError.class, () -> this.serviceRegistry.inject((ServiceProvider)serviceProvider));
    }

    @Test
    void getService() throws Exception {
        MatcherAssert.assertThat((Object)this.serviceRegistry.getService(FooService.class), (Matcher)Is.is(Optional.empty()));
        FooService service = this.mockFooService();
        MatcherAssert.assertThat((Object)this.serviceRegistry.getService(FooService.class), (Matcher)Is.is(Optional.of(service)));
    }

    @Test
    void injectionBySetter() throws Exception {
        FooService service = this.mockFooService();
        InjectableServiceProviderWithSetter serviceProvider = new InjectableServiceProviderWithSetter();
        this.serviceRegistry.inject((ServiceProvider)serviceProvider);
        MatcherAssert.assertThat((Object)serviceProvider.fooService, (Matcher)Is.is((Object)service));
    }

    @Test
    void defaultInstance() {
        MatcherAssert.assertThat((Object)ServiceRegistry.create(), (Matcher)IsInstanceOf.instanceOf(DefaultServiceRegistry.class));
    }

    public static interface FooService
    extends Service {
    }

    public static class InjectableServiceProvider
    implements ServiceProvider {
        @Inject
        private FooService fooService;

        public ServiceDefinition getServiceDefinition() {
            return null;
        }
    }

    public static class InjectableServiceProviderWithSetter
    implements ServiceProvider {
        private FooService fooService;

        @Inject
        public void setFooService(FooService fooService) {
            this.fooService = fooService;
        }

        public ServiceDefinition getServiceDefinition() {
            return null;
        }
    }

    public static class NoInjectableServiceProvider
    implements ServiceProvider {
        @Inject
        private String message;

        public ServiceDefinition getServiceDefinition() {
            return null;
        }
    }
}

